/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stddef.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"


/*
** This function allows external library access to parse an s-expression.
** Return value is zero for okay, -1 for UNIX error and positive value
** to represent particular s-expression failure.
*/

int sexpr_parse( sexpr_t **ret_sexpr, const char *str )
{
	const unsigned long	initial_depth = 0;
	int	end_of_list_flag, ret;
	sexpr_value_t	car;

	assert( ret_sexpr != (sexpr_t **)0 );
	assert( str != (char *)0 );

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fputs( "parsing s-expr [", stderr );
		(void) fputs( str, stderr );
		(void) fputs( "]\n", stderr );
	}

	ret = _sexpr_assign_car( &car, &end_of_list_flag, &str, initial_depth );
	if ( ret != 0 ) {
		RETURN_INT( ret );
	}

	if ( end_of_list_flag ) {
		/*
		** Missing right parenthesis.
		*/
		ret = SEXPR_RPAREN;
	} else {
		ret = 0;
	}

	*ret_sexpr = car.value_u.list;

	RETURN_INT( ret );
}
