/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"


/*
** This function parses a command line argument in the format: %p=999.
*/
int cmd_line_parse_tag( dfile_tag_t **dfile_tag_tbl, unsigned short *dfile_tag_tbl_cnt, char *tag_str )
{
	size_t	alloc_size;
	dfile_tag_t	*new;

	assert( dfile_tag_tbl != (dfile_tag_t **)0 );
	assert( dfile_tag_tbl_cnt != (unsigned short *)0 );
	assert( tag_str != (char *)0 );

	DEBUG_FUNC_START;

	/*
	** This function expects tag_str to contain a tag in the form of
	** %x=value.
	*/
	if ( tag_str[ 0 ] != '%' || tag_str[ 2 ] != '=' ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "tag [", stderr );
		(void) fputs( tag_str, stderr );
		(void) fputs( "] is not in correct format.\n", stderr );
		RETURN_INT( -1 );
	}

	/*
	** Replace '=' with null character.
	*/
	tag_str[ 2 ] = (char)0;

	alloc_size = sizeof( dfile_tag_t ) * ( (size_t)*dfile_tag_tbl_cnt + (size_t)1 );
	new = (dfile_tag_t *)realloc( *dfile_tag_tbl, alloc_size );
	if ( new == (dfile_tag_t *)0 ) {
		UNIX_ERROR( "realloc() failed" );
		RETURN_INT( -1 );
	}

	new[ *dfile_tag_tbl_cnt ].tag = tag_str;
	new[ *dfile_tag_tbl_cnt ].tag_value = &tag_str[ 3 ];

	*dfile_tag_tbl = new;
	++*dfile_tag_tbl_cnt;

	RETURN_INT( 0 );
}
