/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function is called by user program to format and write a record.
** Function dfile_write_open() is expected to have been previously called.
*/

int dfile_write( dfile_t *dfile )
{
	dfile_buffer_t	*buffer;

	DEBUG_FUNC_START;

	if ( dfile == (dfile_t *)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Function argument to dfile_write() cannot be null.\n", stderr );
		abort();
	}

	assert( dfile->bind_cnt > (unsigned short)0 );
	assert( dfile->bind != (dfile_bind_t *)0 );

	assert( dfile->file_name != (char *)0 );

	if ( dfile->error != Dfile_ok ) {
		RETURN_INT( -1 );
	}

	buffer = dfile->application_buffer;
	assert( buffer != (dfile_buffer_t *)0 );

#ifdef DFILE_THREAD
	if ( dfile->buffer_cnt > (unsigned short)1 ) {
		if ( _dfile_buffer_wait( buffer, Dfile_format_state, dfile->buffer_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}
	}
#endif

	if ( dfile->error != Dfile_ok ) {
		RETURN_INT( -1 );
	}

	if ( dfile->record_type == Dfile_delimited ) {
		if ( _dfile_process_delimited_record( dfile, buffer ) == -1 ) {
			RETURN_INT( -1 );
		}
	} else {
		if ( _dfile_process_variable_record( dfile, buffer ) == -1 ) {
			RETURN_INT( -1 );
		}
	}

	++buffer->buffer_rec_cnt;
	++dfile->file_rec_cnt;

	if ( dfile->error != Dfile_ok ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
