/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function chooses the correct I/O buffer function to call based on
** ASCII vs. GZIP I/O.
*/

int _dfile_set_refill_buffer_func( dfile_t *dfile )
{

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	switch ( dfile->format ) {
	case Dfile_zipped:
		if ( dfile->record_type == Dfile_variable_length ) {
			dfile->io_buffer_func = _dfile_var_rec_refill_zipped_buffer;
		} else {
			assert( dfile->record_type == Dfile_delimited );
			dfile->io_buffer_func = _dfile_refill_zipped_buffer;
		}
		break;
	case Dfile_ascii:
		if ( dfile->record_type == Dfile_variable_length ) {
			dfile->io_buffer_func = _dfile_var_rec_refill_ascii_buffer;
		} else {
			assert( dfile->record_type == Dfile_delimited );
			dfile->io_buffer_func = _dfile_refill_ascii_buffer;
		}
		break;
	default:
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Programming error--did not expect format value ", stderr );
		(void) fput_int( dfile->format, stderr );
		(void) fputs( ".\n", stderr );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
