/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function reads the file that contains field names for data record
** layout. Results are returned to calling function using and array of
** dfile_bind_t structures.
*/

int _dfile_read_registry_field_file( char ***field, unsigned short *field_cnt, FILE *fptr )
{
	char	rec[256], *field_name;
	char **field_tbl, *new;
	unsigned short	field_tbl_cnt, rec_cnt;
	size_t	len, alloc_size;

	assert( field != (char ***)0 );
	assert( field_cnt != (unsigned short *)0 );
	assert( fptr != (FILE *)0 );

	DEBUG_FUNC_START;

	field_tbl = (char **)0;
	field_tbl_cnt = (unsigned short)0;
	rec_cnt = (unsigned short)0;

	for ( ;; ) {
		++rec_cnt;
		errno = 0;
		if ( fgets( rec, sizeof( rec ), fptr ) == (char *)0 ) {
			if ( errno == 0 ) {
				/*
				** End of file.
				*/
				break;
			}

			UNIX_ERROR( "fgets() failed" );
			FPUT_SRC_CODE( stderr );
			(void) fputs( "fgets() failed to read record ", stderr );
			(void) fput_ushort( rec_cnt, stderr );
			(void) fputs( ".\n", stderr );
			RETURN_INT( -1 );
		}

		len = strlen( rec );
		if ( len == (size_t)0 ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "fgets() failed to return string of text for record ", stderr );
			(void) fput_ushort( rec_cnt, stderr );
			(void) fputs( ".\n", stderr );
			RETURN_INT( -1 );
		}

		--len;

		if ( rec[ len ] != '\n' ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "fgets() encountered line of text with length greater than ", stderr );
			(void) fput_uint( sizeof( rec ), stderr );
			(void) fputs( " for record ", stderr );
			(void) fput_ushort( rec_cnt, stderr );
			(void) fputs( ".\n", stderr );
			RETURN_INT( -1 );
		}

		_dfile_parse_registry_field_rec( &field_name, rec, rec_cnt );

		if ( field_name == (char *)0 ) {
			/*
			** Field name  was not specified (blank line).
			*/
			continue;
		}

		alloc_size = sizeof( char * ) * (size_t)( field_tbl_cnt + 1 );
		field_tbl = (char **)realloc( (void *)field_tbl, alloc_size );
		if ( field_tbl == (char **)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( -1 );
		}

		new = strdup( field_name );
		if ( new == (char *)0 ) {
			UNIX_ERROR( "strdup() failed" );
			RETURN_INT( -1 );
		}

		field_tbl[ field_tbl_cnt ] = new;

		++field_tbl_cnt;
	}

	if ( field_tbl_cnt == (unsigned short)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "No records were found in DFile field definition file.\n", stderr );
		RETURN_INT( -1 );
	}

	*field = field_tbl;
	*field_cnt = field_tbl_cnt;

	RETURN_INT( 0 );
}
