/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <assert.h>
#include <zlib.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function reads GZIP data into raw GZIP buffer.
*/

int _dfile_read_gz_file( dfile_t *dfile )
{
	ssize_t	read_byte_cnt;
	z_streamp	zstream;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	zstream = (z_streamp)dfile->zstream;
	assert( zstream != (z_stream *)0 );
	assert( dfile->zipped_buffer != (unsigned char *)0 );
	assert( dfile->buffer_length > (size_t)0 );
	assert( dfile->io_buffer != (dfile_buffer_t *)0 );

	read_byte_cnt = read( dfile->open_descriptor, (void *)dfile->zipped_buffer, dfile->buffer_length );
	if ( read_byte_cnt < (ssize_t)0 ) {
		dfile->error = Dfile_io_failed;
		dfile->io_buffer->processing_complete_flag = 'Y';
		UNIX_ERROR( "read() failed" );
		RETURN_INT( -1 );
	}
	if ( read_byte_cnt == (ssize_t)0 ) {
		dfile->error = Dfile_end_of_file;
		RETURN_INT( -1 );
	}
	zstream->avail_in = (unsigned int)read_byte_cnt;
	zstream->next_in = dfile->zipped_buffer;

	RETURN_INT( 0 );
}
