/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function copies values from bind variables to buffer in
** variable record format.
*/
int _dfile_process_variable_record( dfile_t *dfile, dfile_buffer_t *buffer )
{
	unsigned short	field_ndx, field_cnt;
	size_t	partial_len, field_len, unused_len;
	char	*buf_ptr, *buf_ptr_end, *value;
	dfile_bind_t	*bind;

	assert( dfile != (dfile_t *)0 );
	assert( buffer != (dfile_buffer_t *)0 );

	DEBUG_FUNC_START;

	field_cnt = dfile->bind_cnt;
	bind = dfile->bind;

	buf_ptr = buffer->buf_ptr;
	buf_ptr_end = buffer->buf_ptr_end;

	for ( field_ndx = (unsigned short)0; field_ndx < field_cnt; ++field_ndx ) {
		if ( bind->field_length == (size_t *)0 ) {
			field_len = strlen( *bind->field_buffer );
		} else {
			field_len = *bind->field_length;
		}
		if ( field_len > (size_t)UCHAR_MAX ) {
			if ( dfile->record_failure_func != (int (*)( dfile_t *, unsigned short ) )0 ) {
				if ( dfile->record_failure_func( dfile, field_ndx ) == -1 ) {
					RETURN_INT( -1 );
				}
			}

			field_len = (size_t)UCHAR_MAX;
		}
		value = *bind->field_buffer;
		++bind;

		if ( buf_ptr >= buf_ptr_end ) {
			buffer->buf_ptr = buf_ptr;
			if ( _dfile_advance_buffer( dfile, buffer ) == -1 ) {
				RETURN_INT( -1 );
			}
			buffer = dfile->application_buffer;
			buf_ptr = buffer->buf_ptr;
			buf_ptr_end = buffer->buf_ptr_end;
		}

		*(unsigned char *)buf_ptr = (unsigned char)field_len;

		++buf_ptr;

		if ( field_len == (size_t)0 ) {
			continue;
		}

		unused_len = (size_t)( buf_ptr_end - buf_ptr );
		if ( unused_len >= field_len ) {
			(void) memcpy( (void *)buf_ptr, (void *)value, field_len );
			buf_ptr = &buf_ptr[ field_len ];
			continue;
		}

		(void) memcpy( (void *)buf_ptr, (void *)value, unused_len );

		buffer->buf_ptr = buf_ptr_end;
		if ( _dfile_advance_buffer( dfile, buffer ) == -1 ) {
			RETURN_INT( -1 );
		}
		buffer = dfile->application_buffer;
		buf_ptr = buffer->buf_ptr;
		buf_ptr_end = buffer->buf_ptr_end;

		partial_len = field_len - unused_len;
		value += unused_len;

		(void) memcpy( (void *)buf_ptr, (void *)value, partial_len );
		buf_ptr += partial_len;
	}

	buffer->buf_ptr = buf_ptr;

	RETURN_INT( 0 );
}
