/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function parses a field from a registry field record. A file
** containing registry field information describes field names and their
** order in the data record layout. Field separator is expected to be one
** or more white space characters. Only one record field (data field name)
** is expected.
*/

void _dfile_parse_registry_field_rec( char **field_name, char *rec, unsigned short rec_cnt )
{
	int	ret;

	assert( field_name != (char **)0 );
	assert( rec != (char *)0 );

	DEBUG_FUNC_START;

	*field_name = (char *)0;

	if ( _dfile_skip_spaces( &rec ) == -1 ) {
		/*
		** End of line reached.
		*/
		RETURN_VOID;
	}

	*field_name = rec;
	ret = _dfile_parse_registry_field( &rec );

	if ( Debug ) {
		(void) fputs( "field name [", stderr );
		(void) fputs( *field_name, stderr );
		(void) fputs( "]\n", stderr );
	}

	if ( ret == -1 ) {
		/*
		** End of line reached.
		*/
		RETURN_VOID;
	}

	if ( _dfile_skip_spaces( &rec ) == -1 ) {
		/*
		** End of line reached.
		*/
		RETURN_VOID;
	}

	FPUT_SRC_CODE( stderr );
	(void) fputs( "Record ", stderr );
	(void) fput_ushort( rec_cnt, stderr );
	(void) fputs( " associated with [", stderr );
	(void) fputs( *field_name, stderr );
	(void) fputs( "] in DFile field definition file had unexpected format.\n", stderr );

	RETURN_VOID;
}
