/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function parses a record in the variable length field format.
*/

dfile_parse_t _dfile_get_var_record( dfile_t *dfile )
{
	dfile_buffer_t	*buffer;
	unsigned short	field_ndx, bind_cnt, bind_processed_cnt;
	char	*buf_ptr, *buf_ptr_end, *next_field;
	size_t	field_length;
	dfile_bind_t	*bind;
	dfile_parse_t	parse_status;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	buffer = dfile->application_buffer;
	assert( buffer != (dfile_buffer_t *)0 );
	assert( buffer->state != (dfile_state_t *)0 );

	bind_cnt = dfile->bind_cnt;
	buf_ptr_end = buffer->buf_ptr_end;
	next_field = (char *)0;

	if ( dfile->read_var_rec.current_bind == (dfile_bind_t *)0 ) {
		/*
		** Parse next record.
		*/
		bind = dfile->bind;
		buf_ptr = buffer->buf_ptr;
		if ( buf_ptr >= buf_ptr_end ) {
			/*
			** Reached end of buffer.
			*/
			RETURN_INT( Dfile_parse_failed );
		}
		if ( dfile->read_var_rec.use_next_field_len_flag ) {
			field_length = (size_t)dfile->read_var_rec.next_field_len;
			dfile->read_var_rec.next_field_len = (unsigned char)0;
			/*
			** Set use_next_field_len_flag to false.
			*/
			dfile->read_var_rec.use_next_field_len_flag = (char)0;
		} else {
			/*
			** Beginning of buffer.
			*/
			field_length = (size_t) *(unsigned char *)buf_ptr;
			++buf_ptr;
		}
		dfile->read_var_rec.start_of_record = buf_ptr;
		field_ndx = (unsigned short)0;
		++dfile->file_rec_cnt;
		++buffer->buffer_rec_cnt;
	} else {
		/*
		** Continue parsing record.
		*/
		_dfile_var_record_append_overflow( dfile );
		bind = dfile->read_var_rec.current_bind;
		buf_ptr = buffer->buf_ptr;
		field_ndx = dfile->read_var_rec.processed_field_cnt;
		(void) memset( (void *)&dfile->read_var_rec, 0, sizeof( dfile->read_var_rec ) );
		field_length = (size_t) *(unsigned char *)buf_ptr;
		++buf_ptr;
	}

	if ( Debug ) {
		(void) fprintf( stderr, "parsing record %lu buffer, %lu file, from buffer %hu.\n", buffer->buffer_rec_cnt, dfile->file_rec_cnt, buffer->buffer_id );
	}

	assert( bind != (dfile_bind_t *)0 );
	bind_processed_cnt = (unsigned short)0;

	for ( ; field_ndx < bind_cnt; ++field_ndx ) {
		next_field = &buf_ptr[ field_length ];

		if ( bind->field_length != (size_t *)0 ) {
			*bind->field_length = field_length;
		}

		*bind->field_buffer = buf_ptr;
		++bind;
		++bind_processed_cnt;

		buf_ptr = next_field;

		if ( next_field >= buf_ptr_end ) {
			/*
			** Reached end of buffer.
			*/
			if ( next_field == buf_ptr_end ) {
				++field_ndx;
				field_length = (size_t)0;
			}
			break;
		}

		field_length = (size_t) *(unsigned char *)buf_ptr;
		*buf_ptr = (char)0;
		++buf_ptr;
	}

	assert( field_ndx <= bind_cnt );

	if ( field_ndx == bind_cnt ) {
		/*
		** Parsed entire reocrd.
		*/
		buffer->buf_ptr = buf_ptr;
		dfile->read_var_rec.start_of_record = (char *)0;
		if ( buf_ptr_end >= buf_ptr && buf_ptr > next_field ) {
			dfile->read_var_rec.next_field_len = (unsigned char)field_length;
			/*
			** Set use_next_field_len_flag to true.
			*/
			dfile->read_var_rec.use_next_field_len_flag = (char)1;
		}
		parse_status = Dfile_parsed_record;
	} else {
		/*
		** Parsed partial record and reached end of buffer.
		*/
		if ( _dfile_var_record_save_overflow( dfile, buf_ptr, buffer, next_field, field_ndx, bind_processed_cnt ) == -1 ) {
			RETURN_INT( Dfile_fatal_parse_error );
		}
		parse_status = Dfile_parse_failed;

	}

	RETURN_INT( parse_status );
}
