/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <sched.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


#if DFILE_THREAD
/*
** This function is called to check the availability of a buffer.
** If it's unavailable, wait until it becomes available.
*/

int _dfile_buffer_wait( dfile_buffer_t *buffer, dfile_buffer_state_t wanted_state, unsigned short buffer_cnt )
{
	int	ret;

	assert( buffer != (dfile_buffer_t *)0 );
	assert( buffer_cnt > (unsigned short)1 );

	if ( Debug ) {
		(void) fprintf( stderr, "%s() started for thread %u waiting for buffer %hu at %s\n", func, pthread_self(), buffer->buffer_id, get_ctime() );
	}

	assert( buffer->state != (dfile_state_t *)0 );

	for ( ;; ) {
		if ( buffer->thread_id != pthread_self() ) {
			if ( Debug ) {
				(void) fputs( "calling pthread_mutex_lock()\n", stderr );
			}
			ret = pthread_mutex_lock( &buffer->mutex );
			if ( ret != 0 ) {
				thread_error( "pthread_mutex_lock() failed", __FILE__, __LINE__, ret );
				RETURN_INT( -1 );
			}
			buffer->thread_id = pthread_self();
			if ( Debug ) {
				(void) fprintf( stderr, "thread %u, mutex lock complete\n", pthread_self() );
			}
		}

#if 0
fprintf( stderr, "buffer state %p, %d, %d\n", buffer, buffer->state->buffer_state, wanted_state );
#endif

		if ( buffer->state->buffer_state == wanted_state ) {
			break;
		}

		if ( Debug ) {
			(void) fprintf( stderr, "thread %u, not correct buffer state\n", pthread_self() );
		}

		buffer->thread_id = (pthread_t)0;
		pthread_mutex_unlock( &buffer->mutex );
		if ( Debug ) {
			(void) fprintf( stderr, "thread %u, mutex unlock complete\n", pthread_self() );
		}

		/*
		** Should only be possible to reach this point prior to
		** filling the first buffer.
		*/

		sched_yield();
	}

	if ( Debug ) {
		(void) fprintf( stderr, "Thread %u acquired buffer %hu.\n", pthread_self(), buffer->buffer_id );
	}

	RETURN_INT( 0 );
}
#endif
