/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <zlib.h>
#include "tbox.h"
#include "dfile.h"


/*
** This function allocates memory used during compression operations.
** It is specially initialized based on whether the process is reading
** from or writing to a file.
*/

int _dfile_allocate_zipped_stream( dfile_t *dfile, char read_write_flag )
{
	z_stream	*zstream;
	int	zerr;

	assert( dfile != (dfile_t *)0 );
	assert( read_write_flag == 'r' || read_write_flag == 'w' );

	DEBUG_FUNC_START;

	dfile->zipped_buffer = (unsigned char *)malloc( dfile->buffer_length );
	if ( dfile->zipped_buffer == (unsigned char *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	zstream = (z_stream *)malloc( sizeof( z_stream ) );
	if ( zstream == (z_stream *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	(void) memset( (void *)zstream, 0, sizeof( z_stream ) );

	if ( read_write_flag == 'r' ) {
		if ( inflateInit2( zstream, -MAX_WBITS ) != Z_OK ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Function inflateInit2() failed.\n", stderr );
			RETURN_INT( -1 );
		}
	} else {
		zerr = deflateInit2( zstream, Z_DEFAULT_COMPRESSION, Z_DEFLATED, -MAX_WBITS, MAX_MEM_LEVEL, Z_DEFAULT_STRATEGY );
		if ( zerr != Z_OK ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Function deflateInit2() failed (", stderr );
			(void) fput_int( zerr, stderr );
			(void) fputs( ").\n", stderr );
			RETURN_INT( -1 );
		}

		zstream->next_out = dfile->zipped_buffer;
		zstream->avail_out = dfile->buffer_length;
	}

	dfile->zstream = (void *)zstream;

	RETURN_INT( 0 );
}
