/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <time.h>


/*LINTSTDLIB*/

typedef enum { Read_fatal = -1, Read_ok = 0, Read_eof = 100, Read_err = 200 } readstat_t;

int str_to_unix_time( time_t *, const char * );

void unix_error( const char *, const char *, int );

void thread_error( const char *, const char *, int, int );

int substitute_str( char *, size_t, const char *, const char * );

typedef enum { Dh_ok = 0, Dh_alloc, Dh_collision } dherrno_t;

void *dhcreate( unsigned long, unsigned long );
void *dhsearch( const void *, void *, unsigned long ( * )( const void * ), int ( * )( const void *, const void * ) );
void *dhesearch( const void *, void **, unsigned long ( * )( const void * ), int ( * )( const void *, const void * ) );
void *dhfind( const void *, const void *, unsigned long, int ( * )( const void *, const void * ) );
void *dhdelete( const void *, const void *, unsigned long, int ( * )( const void *, const void * ) );
dherrno_t dherror( void );
unsigned long dhused_buckets( void * );
unsigned long dhtotal_buckets( void * );
unsigned long dhallowed_collisions( void * );
int dhis_occupied_bucket( const void * );
void dhtable( const void *, const void **, unsigned long * );

unsigned long strhkey( const char * );
int isprime( unsigned long, unsigned short );

const char	*fmt_ctime( void ), *get_ctime( void );

char *strenv( const char * );

size_t trim_spaces( char * );

int glob_fname( const char ***, const char * );

void *nubsearch( const void *, const void *, size_t, size_t, int (*) ( const void *, const void * ) );

void *nubsearch_next( const void *, const void *, size_t, size_t, int (*) ( const void *, const void * ) );

int atod( double *, const char * );
const char *xdtoa( double );
const char *stoa( short );
const char *ustoa( unsigned short );
const char *ltoa( long );
const char *ultoa( unsigned long );
const char *itoa( int );
const char *utoa( unsigned int );

int fput_double( double, FILE * );
int fput_short( short, FILE * );
int fput_ushort( unsigned short, FILE * );
int fput_long( long, FILE * );
int fput_ulong( unsigned long, FILE * );
int fput_int( int, FILE * );
int fput_uint( unsigned int, FILE * );
void fput_src_code( const char *, int, FILE * );

int load_text_file( char ***, unsigned long *, const char * );

void *psearch (const void *, const void *, size_t, size_t, int (*) (const void *, const void *));

int file_basename( const char **, const char ***, unsigned short *, const char * );

FILE *cfg_open( const char *, const char * );
readstat_t cfg_lookup( const char **, unsigned short, char, const char *, const char *, const char * );
readstat_t cfg_read( const char **, unsigned short, unsigned long *, char, FILE *, const char * );

int parse_list( char ***, unsigned long *, const char *, char );

int heap_sort( void *, size_t, size_t, int ( * )(const void *, const void * ) );
int insertion_sort( void *, size_t, size_t, int ( * )(const void *, const void * ) );
void internal_insertion_sort( void *, size_t, size_t, int ( * )(const void *, const void * ), void * );
int merge_sort( void *, size_t, size_t, int ( * )(const void *, const void * ) );
int shell_sort( void *, size_t, size_t, int ( * )(const void *, const void * ) );

void strtoupper( char * );
int strnncmp( const char *, size_t, const char *, size_t );

int load_script_file( char **, size_t *, const char *, char );

#ifdef NDEBUG
#define	Debug	0

#define DEBUG_FUNC_START
#define RETURN_INT( x )		return x
#define RETURN_POINTER( x )	return x
#define RETURN_VOID		return
#else
extern int	Debug;
#define DEBUG_FUNC_START	if ( Debug ) (void) fprintf( stderr, Start_func_msg, __func__, get_ctime() )

#define RETURN_INT( x ) 	if ( Debug ) { (void) fprintf( stderr, End_func_msg_int, __func__, ( x ), get_ctime() ); } return ( x )

#define RETURN_POINTER( x ) 	if ( Debug ) { (void) fprintf( stderr, End_func_msg_pointer, __func__, ( x ), get_ctime() ); } return ( x )

#define RETURN_VOID 	if ( Debug ) { (void) fprintf( stderr, End_func_msg_void, __func__, get_ctime() ); } return
#endif

extern const char	Start_func_msg[];
extern const char	End_func_msg_int[];
extern const char	End_func_msg_pointer[];
extern const char	End_func_msg_void[];

#define UNIX_ERROR( x )	unix_error( x, __FILE__, __LINE__ )
#define THREAD_ERROR( x, y )	thread_error( x, __FILE__, __LINE__, y )
#define FPUT_SRC_CODE( x ) fput_src_code( __FILE__, __LINE__, x )
