/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


static int alloc_key( order_by_t **, unsigned short );

/*
** This function parses command line key argument.
*/
int parse_key_argument( order_by_t **ret_key_tbl, unsigned short *ret_key_tbl_cnt, const char *cmd_line_arg )
{
	const char	*delimiter, *ptr;
	order_by_t	*key_tbl;
	unsigned short key_tbl_cnt;
	const char	expected_delimiter = ',';

	assert( ret_key_tbl != (order_by_t **)0 );
	assert( ret_key_tbl_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	if ( cmd_line_arg == (const char *)0 ) {
		/*
		** using control file
		*/
		RETURN_INT( 0 );
	}

	*ret_key_tbl = (order_by_t *)0;
	*ret_key_tbl_cnt = (unsigned short)0;
	key_tbl = (order_by_t *)0;
	key_tbl_cnt = (unsigned short)0;

	if ( *cmd_line_arg == (char)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Command line argument was zero length.\n", stderr );
		RETURN_INT( -1 );
	}

	ptr = cmd_line_arg;
	while ( ( delimiter = strchr( ptr, expected_delimiter ) ) != (char *)0 ) {
		if ( alloc_key( &key_tbl, key_tbl_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( parse_one_key( &key_tbl[ key_tbl_cnt ], ptr, delimiter ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( Debug ) {
			(void) fprintf( stderr, "key: field_name [%s], ascend_descend %c, value_type %c\n", key_tbl[ key_tbl_cnt ].field_name, key_tbl[ key_tbl_cnt ].ascend_descend, key_tbl[ key_tbl_cnt ].value_type );
		}

		++key_tbl_cnt;
		ptr = &delimiter[ 1 ];
	}

	if ( *ptr != (char)0 ) {
		/*
		** Get address of null character.
		*/
		delimiter = &ptr[ strlen( ptr ) ];

		if ( alloc_key( &key_tbl, key_tbl_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( parse_one_key( &key_tbl[ key_tbl_cnt ], ptr, delimiter ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( Debug ) {
			(void) fprintf( stderr, "key: field_name [%s], ascend_descend %c, value_type %c\n", key_tbl[ key_tbl_cnt ].field_name, key_tbl[ key_tbl_cnt ].ascend_descend, key_tbl[ key_tbl_cnt ].value_type );
		}

		++key_tbl_cnt;
	}

	*ret_key_tbl = key_tbl;
	*ret_key_tbl_cnt = key_tbl_cnt;

	RETURN_INT( 0 );
}

static int alloc_key( order_by_t **key_tbl, unsigned short key_tbl_cnt )
{
	size_t	alloc_size;
	order_by_t	*new;

	alloc_size = sizeof( order_by_t ) * ( (size_t)key_tbl_cnt + (size_t)1 );

	new = (order_by_t *)realloc( (void *)*key_tbl, alloc_size );

	if ( new == (order_by_t *)0 ) {
		UNIX_ERROR( "realloc() failed" );
		return -1;
	}

	*key_tbl = new;

	return 0;
}
