/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function opens data files for reading.
*/
int open_merge_input( dfile_t ***dfile_tbl, const char *dfile_name, dfile_tag_t *tag_tbl, unsigned short tag_tbl_cnt, int thread_input_flag, sm_dfile_t **merge_tbl, unsigned short *merge_cnt )
{
	unsigned short	ndx;
	dfile_t	**new;
	size_t	alloc_size;
	static sm_dfile_t	cmd_line;
	sm_dfile_t	*merge;

	assert( dfile_tbl != (dfile_t ***)0 );
	assert( merge_tbl != (sm_dfile_t **)0 );
	assert( merge_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	*dfile_tbl = (dfile_t **)0;

	if ( dfile_name == (const char *)0 && *merge_cnt == (unsigned short)0) {
		/*
		** No files to merge.
		*/
		RETURN_INT( 0 );
	}

	if ( dfile_name != (const char *)0 ) {
		/*
		** Used command line instead of control file.
		*/
		assert( *merge_cnt == (unsigned short)0 );
		assert( *merge_tbl == (sm_dfile_t *)0 );

		cmd_line.dfile_name = dfile_name;
		cmd_line.tag = tag_tbl;
		cmd_line.tag_cnt = tag_tbl_cnt;
		cmd_line.where = (void *)0;
		cmd_line.blocks_per_buffer_cnt = (unsigned short)4;
		if ( thread_input_flag ) {
			cmd_line.buffer_cnt = (unsigned short)3;
		} else {
			cmd_line.buffer_cnt = (unsigned short)1;
		}

		*merge_tbl = &cmd_line;
		*merge_cnt = (unsigned short)1;
	}

	alloc_size = (size_t)*merge_cnt * sizeof( dfile_t * );
	new = (dfile_t **)malloc( alloc_size );
	if ( new == (dfile_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	merge = *merge_tbl;

	for ( ndx = (unsigned short)0; ndx < *merge_cnt; ++ndx ) {
		if ( append_tag( &merge->tag, &merge->tag_cnt, tag_tbl, tag_tbl_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( open_input( &new[ ndx ], merge->dfile_name, merge->tag, merge->tag_cnt, merge->blocks_per_buffer_cnt, merge->buffer_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		++merge;
	}

	*dfile_tbl = new;

	RETURN_INT( 0 );
}
