/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#define _THREAD_SAFE
#define _THREAD_SAFE_ERRNO
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <errno.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


static double convert_to_double( const char * );

/*
** This function does a numeric comparison between strings.
*/
int numeric_cmp( const char *x, const char *y )
{
	double	lhs, rhs;

	assert( x != (const char *)0 );
	assert( y != (const char *)0 );

	DEBUG_FUNC_START;

	lhs = convert_to_double( x );
	rhs = convert_to_double( y );

	if ( lhs > rhs ) {
		RETURN_INT( 1 );
	}

	if ( lhs < rhs ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}

static double convert_to_double( const char *x )
{
	char	*ptr;
	double	result;

	if ( *x == (char)0 ) {
		return 0.0;
	}

	errno = 0;
	result = strtod( x, &ptr );

	if ( Debug ) {
		if ( errno != 0 || x == ptr ) {
			fprintf( stderr, "Failed to convert [%s] to a floating point number, errno = %d.\n", x, errno );
		}
	}

	return result;
}
