/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function does an ASCII comparison between strings, but considers
** a zero length string to be a high value.
*/
int high_value_null_cmp( const char *lhs_str, size_t lhs_len, const char *rhs_str, size_t rhs_len )
{
	int	ret, lhs_null_flag, rhs_null_flag;

	assert( lhs_str != (const char *)0 );
	assert( rhs_str != (const char *)0 );

	DEBUG_FUNC_START;

	lhs_null_flag = ( *lhs_str == (char)0 ) ? 1 : 0;
	rhs_null_flag = ( *rhs_str == (char)0 ) ? 1 : 0;

	if ( lhs_null_flag && rhs_null_flag ) {
		RETURN_INT( 0 );
	}

	if ( lhs_null_flag ) {
		assert( !rhs_null_flag );
		RETURN_INT( 1 );
	}

	if ( rhs_null_flag ) {
		assert( !lhs_null_flag );
		RETURN_INT( -1 );
	}

	/*
	** To reach this point, neither string was zero length.
	*/
	assert( !rhs_null_flag );
	assert( !lhs_null_flag );

	ret = strnncmp( lhs_str, lhs_len, rhs_str, rhs_len );

	RETURN_INT( ret );
}
