/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


/*
** This function copies a sorted record to a bind structure.
*/
void copy_record_to_bind( dfile_bind_t *bind, unsigned short bind_cnt, field_t *rec )
{
	field_t	*field;

	assert( bind != (dfile_bind_t *)0 );
	assert( rec != (field_t *)0 );

	DEBUG_FUNC_START;

	field = rec;
	for ( ; bind_cnt > (unsigned short)0; --bind_cnt ) {
		*bind->field_buffer = field->value;
		*bind->field_length = field->length;
		++bind;
		++field;
	}

	RETURN_VOID;
}
