/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"


static int allocate_sort( sm_dfile_t **, unsigned short * );

/*
** This function assigns information from control structure.
*/
int assign_sort( sm_dfile_t **ret_sort, unsigned short *ret_sort_cnt, char *sort_algorithm, sexpr_t *dfile, unsigned short tuple_cnt )
{
	char	*section;
	int	ret;
	sm_dfile_t	*sort, *new;
	unsigned short	sort_cnt;
	sexpr_t	*dfile_attribute;

	assert( ret_sort != (sm_dfile_t **)0 );
	assert( ret_sort_cnt != (unsigned short *)0 );
	/*
	** sort_algorithm will be null for merge.
	*/

	DEBUG_FUNC_START;

	sort = (sm_dfile_t *)0;
	new = (sm_dfile_t *)0;
	sort_cnt = (unsigned short)0;

	while ( dfile != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( dfile ) != list_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a list", tuple_cnt );
			RETURN_INT( -1 );
		}

		dfile_attribute = SEXPR_CAR_LIST( dfile );

		if ( SEXPR_CAR_TYPE( dfile_attribute ) != string_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
			RETURN_INT( -1 );
		}

		section = SEXPR_CAR_STRING( dfile_attribute );

		if ( Debug ) {
			(void) fprintf( stderr, "section [%s]\n", section );
		}

		assert( SEXPR_CDR_TYPE( dfile_attribute ) == list_sexpr );

		dfile_attribute = SEXPR_CDR_LIST( dfile_attribute );

		if ( dfile_attribute == (sexpr_t *)0 || SEXPR_CAR_TYPE( dfile_attribute ) != string_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
			RETURN_INT( -1 );
		}

		if ( Debug ) {
			(void) fprintf( stderr, "attribute [%s]\n", SEXPR_CAR_STRING( dfile_attribute ) );
		}

		if ( strcmp( section, "dfile" ) == 0 ) {
			ret = allocate_sort( &new, &sort_cnt );
			if ( ret == -1 ) {
				RETURN_INT( -1 );
			}

			sort = &new[ sort_cnt - 1 ];

			sort->dfile_name = SEXPR_CAR_STRING( dfile_attribute );

			if ( Debug ) {
				fprintf( stderr, "found dfile [%s]\n", sort->dfile_name );
			}

			assert( SEXPR_CDR_TYPE( dfile_attribute ) == list_sexpr );

			ret = assign_sort_dfile( sort, SEXPR_CDR_LIST( dfile_attribute ), tuple_cnt );
			if ( ret != 0 ) {
				RETURN_INT( ret );
			}
		} else {
			if ( sort_algorithm != (char *)0 && strcmp( section, "algorithm" ) == 0 ) {
				ret = assign_algorithm( sort_algorithm, dfile_attribute, tuple_cnt );
				if ( ret != 0 ) {
					RETURN_INT( ret );
				}
			}
		}

		assert( SEXPR_CDR_TYPE( dfile ) == list_sexpr );

		dfile = SEXPR_CDR_LIST( dfile );
	}

	*ret_sort = new;
	*ret_sort_cnt = sort_cnt;

	RETURN_INT( 0 );
}

static int allocate_sort( sm_dfile_t **sort, unsigned short *sort_cnt )
{
	size_t	alloc_size;
	sm_dfile_t	*new;

	alloc_size = sizeof( sm_dfile_t ) * ( (size_t)*sort_cnt + (size_t)1 );
	new = (sm_dfile_t *)realloc( *sort, alloc_size );
	if ( new == (sm_dfile_t *)0 ) {
		UNIX_ERROR( "realloc() failed" );
		return -1;
	}

	*sort = new;
	new += *sort_cnt;
	++*sort_cnt;

	new->tag = (dfile_tag_t *)0;
	new->tag_cnt = (unsigned short)0;
	new->blocks_per_buffer_cnt = (unsigned short)2;
	new->buffer_cnt = (unsigned short)1;
	new->where = (sexpr_t *)0;

	return 0;
}
