/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_sort.h"


/*
** This function adds a link to the merge queue.
*/
int add_to_merge_queue( merge_queue_t **merge_queue, merge_queue_t *link, const order_by_t *key_tbl, unsigned short key_tbl_cnt )
{
	merge_queue_t	*queue, *prev_link;
	int	result;
	dfile_bind_t	*link_bind;
	unsigned short	*link_key_ndx_tbl;

	assert( merge_queue != (merge_queue_t **)0 );
	assert( link != (merge_queue_t *)0 );

	DEBUG_FUNC_START;

	if ( *merge_queue == (merge_queue_t *)0 ) {
		/*
		** Add to empty queue.
		*/
		*merge_queue = link;

		RETURN_INT( 0 );
	}

	queue = *merge_queue;
	link_bind = link->dfile->bind;
	link_key_ndx_tbl = link->key_ndx_tbl;

	result = compare_order_by_bind( link_bind, link_key_ndx_tbl, queue->dfile->bind, queue->key_ndx_tbl, key_tbl, key_tbl_cnt );

	if ( result < 0 ) {
		link->next = queue;
		*merge_queue = link;

		RETURN_INT( 0 );
	}

	prev_link = queue;
	queue = queue->next;
	while ( queue != (merge_queue_t *)0 ) {
		result = compare_order_by_bind( link_bind, link_key_ndx_tbl, queue->dfile->bind, queue->key_ndx_tbl, key_tbl, key_tbl_cnt );

		if ( result < 0 ) {
			link->next = queue;
			prev_link->next = link;

			RETURN_INT( 0 );
		}

		prev_link = queue;
		queue = queue->next;
	}

	link->next = (merge_queue_t *)0;
	prev_link->next = link;

	RETURN_INT( 0 );
}
