/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "where.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"


/*
** This function joins an input record with all join files.
*/
int join_files( dfile_t *output_dfile, const dfile_bind_t **input_field_map_tbl, dfile_bind_t **output_field_map_tbl, unsigned short io_field_map_tbl_cnt, void *input_filter, void *output_filter, join_ctl_t *join_ctl_tbl, unsigned short join_ctl_tbl_cnt )
{
	unsigned short	join_ndx;
	int	compare_result;
	dfile_bind_t	*bind;
	where_result_t	where_result;
	char	err_msg[ 256 ];
	join_ctl_t	*join;

	assert( output_dfile != (dfile_t *)0 );
	assert( input_field_map_tbl != (const dfile_bind_t **)0 );
	assert( output_field_map_tbl != (dfile_bind_t **)0 );
	assert( join_ctl_tbl != (join_ctl_t *)0 );
	assert( join_ctl_tbl_cnt > (unsigned short)0 );
	/*
	** When filters are not used, pointers will be null.
	*/

	DEBUG_FUNC_START;

	if ( input_filter != (void *)0 ) {
		if ( where_condition( &where_result, err_msg, sizeof( err_msg ), input_filter ) != WHERE_NOERR ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "input where_condition() failed [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( -1 );
		}

		if ( where_result == Where_result_false ) {
			/*
			** Skip record.
			*/
			RETURN_INT( 0 );
		}
	}

	copy_input_to_output( output_field_map_tbl, input_field_map_tbl, io_field_map_tbl_cnt );

	join = join_ctl_tbl;

	for ( join_ndx = (unsigned short)0; join_ndx < join_ctl_tbl_cnt; ++join_ndx, ++join ) {
		if ( join->ipc_key == (const char *)0 ) {
			/*
			** Join without shared memory.
			*/
			if ( join->record_cnt == 0UL ) {
				/*
				** Currently no join records are loaded
				** into memory.
				*/
				if ( get_join_records( &join->key_record, &join->key_record_size, &join->copy_record, &join->copy_record_size, &join->record_cnt, join->dfile, (const dfile_bind_t **)join->join_key_tbl, (const dfile_bind_t **)join->input_key_tbl, join->key_field_tbl_cnt, join->where, &join->initial_read_flag, &join->end_of_file_flag, (const dfile_bind_t **)join->join_field_tbl, join->copy_field_tbl_cnt, join->alloc_record_cnt ) == -1 ) {
					RETURN_INT( -1 );
				}
				if ( join->record_cnt > join->alloc_record_cnt ) {
					join->alloc_record_cnt = join->record_cnt;
				}
			} else {
				compare_result = compare_field_bind( *join->key_record, (const dfile_bind_t **)join->input_key_tbl, join->key_field_tbl_cnt );

				if ( compare_result > 0 ) {
					FPUT_SRC_CODE( stderr );
					(void) fputs( "At least one file is not properly sorted.\n", stderr );
					RETURN_INT( -1 );
				}

				if ( compare_result < 0 ) {
					if ( get_join_records( &join->key_record, &join->key_record_size, &join->copy_record,  &join->copy_record_size, &join->record_cnt, join->dfile, (const dfile_bind_t **)join->join_key_tbl, (const dfile_bind_t **)join->input_key_tbl, join->key_field_tbl_cnt, join->where, &join->initial_read_flag, &join->end_of_file_flag, (const dfile_bind_t **)join->join_field_tbl, join->copy_field_tbl_cnt, join->alloc_record_cnt ) == -1 ) {
						RETURN_INT( -1 );
					}

					if ( join->record_cnt > join->alloc_record_cnt ) {
						join->alloc_record_cnt = join->record_cnt;
					}
				}
			}
		} else {
			get_shm_join_records( &join->shm, &join->record_cnt, join->input_key_tbl, join->key_field_tbl_cnt );
		}

		if ( join->record_cnt == 0UL ) {
			/*
			** No records join to this input record.
			*/
			if ( join->inner_outer_join_flag == 'O' ) {
				/*
				** outer join
				*/
				if ( join->outer_join_status_field != (dfile_bind_t *)0 ) {
					/*
					** Set status field to failure.
					*/
					bind = join->outer_join_status_field;
					*bind->field_buffer = "-";
					*bind->field_length = (size_t)1;
				}
			} else {
				/*
				** Inner join failed for input record.
				** Discard input record.
				*/
				RETURN_INT( 0 );
			}
		} else {
			if ( join->outer_join_status_field != (dfile_bind_t *)0 ) {
				/*
				** Set status field to success.
				*/
				bind = join->outer_join_status_field;
				*bind->field_buffer = "+";
				*bind->field_length = (size_t)1;
			}
		}
	}

	if ( write_join( output_dfile, join_ctl_tbl, join_ctl_tbl_cnt - (unsigned short)1, output_filter ) == -1 ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
