/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"


/*
** This function to used to assist debugging. It prints the values in
** the input_ctl_t structure.
*/
void dump_input_ctl( input_ctl_t *input )
{
	unsigned short	ndx;
	map_field_t	*map_field;
	dfile_tag_t	*dfile_tag;

	assert( input != (input_ctl_t *)0 );

	DEBUG_FUNC_START;

	(void) fputs( "input:\n", stderr );

	(void) fprintf( stderr, "\tdfile_name = [%s]\n", input->dfile_name );

#if 0
	(void) fputs( "\tcopy field:\n", stderr );
	for ( ndx = (unsigned short)0; ndx < input->copy_field_tbl_cnt; ++ndx ) {
		(void) fprintf( stderr, "\t\t%d. [%s]\n", ndx + 1, input->copy_field_tbl[ ndx ] );
	}
#endif

	(void) fputs( "\tmap fields: <direction #1> <direction #2>\n", stderr );
	map_field = input->map_field_tbl;
	for ( ndx = (unsigned short)0; ndx < input->map_field_tbl_cnt; ++ndx ) {
		(void) fprintf( stderr, "\t\t%d. [%s] [%s], [%s] [%s]\n", ndx + 1, map_field->field[ 0 ].direction, map_field->field[ 0 ].field_name, map_field->field[ 1 ].direction, map_field->field[ 1 ].field_name );
		++map_field;
	}

	(void) fprintf( stderr, "\trecord_filter = %p\n", input->record_filter );

	(void) fputs( "\tdfile tag: <tag> <tag value>\n", stderr );
	dfile_tag = input->tag;
	for ( ndx = (unsigned short)0; ndx < input->tag_cnt; ++ndx ) {
		(void) fprintf( stderr, "\t\t%d. [%s] [%s]\n", ndx + 1, dfile_tag->tag, dfile_tag->tag_value );
		++dfile_tag;
	}

	(void) fprintf( stderr, "\tblocks_per_buffer_cnt = %hu\n", input->blocks_per_buffer_cnt );
	(void) fprintf( stderr, "\tbuffer_cnt = %hu\n", input->buffer_cnt );
	(void) fputc( '\n', stderr );

	RETURN_VOID;
}
