/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_join.h"


/*
** This function assigns information from control structure.
*/
int assign_copy_fields( char ***copy_field_tbl, unsigned short *copy_field_tbl_cnt, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	str_msg[] = "expected a string";
	sexpr_t	*field_sexpr;
	size_t	alloc_size;
	char	**new;

	assert( copy_field_tbl != (char ***)0 );
	assert( copy_field_tbl_cnt != (unsigned short *)0 );

	DEBUG_FUNC_START;

	if ( sexpr == (sexpr_t *)0 ) {
		control_syntax_error( "expected list", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	field_sexpr = SEXPR_CAR_LIST( sexpr );
	*copy_field_tbl_cnt = (unsigned short)0;
	*copy_field_tbl = (char **)0;

	while ( field_sexpr != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( field_sexpr ) != string_sexpr ) {
			control_syntax_error( str_msg, __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		alloc_size = sizeof( const char * ) * ( (size_t)*copy_field_tbl_cnt + (size_t)1 );
		new = (char **)realloc( (void *)*copy_field_tbl, alloc_size );
		if ( new == (char **)0 ) {
			unix_error( "realloc() failed", __FILE__, __LINE__ );
			RETURN_INT( -1 );
		}

		*copy_field_tbl = new;
		new += *copy_field_tbl_cnt;
		++*copy_field_tbl_cnt;

		*new = (char *)SEXPR_CAR_STRING( field_sexpr );

		if ( Debug ) {
			(void) fprintf( stderr, "field: [%s]\n", *new );
		}

		assert( SEXPR_CDR_TYPE( field_sexpr ) == list_sexpr );

		field_sexpr = SEXPR_CDR_LIST( field_sexpr );
	}

	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	if ( SEXPR_CDR_LIST( sexpr ) != (sexpr_t *)0 ) {
		control_syntax_error( "too many items in list", __FILE__, __LINE__, tuple_cnt );
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
