/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function creates a linked list of proc_t structures.
*/
int set_proc_list( proc_t **proc_list, unsigned short *proc_list_cnt, proc_t *proc_tbl, completed_t *completed, unsigned long completed_cnt, char **divvy_text, unsigned short divvy_text_cnt, const char *step_name, const unsigned char *successful_exit_code )
{
	unsigned short	proc_ndx;
	unsigned short	proc_cnt;
	proc_t	*proc, *trav_proc;
	char	*partition_text;
	int	completed_successful_flag;

	assert( proc_list != (proc_t **)0 );
	assert( proc_list_cnt != (unsigned short *)0 );
	assert( proc_tbl != (proc_t *)0 );
	assert( step_name != (const char *)0 );
	assert( successful_exit_code != (const unsigned char *)0 );

	DEBUG_FUNC_START;

	if ( divvy_text_cnt == (unsigned short)0 ) {
		proc_cnt = (unsigned short)1;
	} else {
		proc_cnt = divvy_text_cnt;
	}

	*proc_list = (proc_t *)0;
	*proc_list_cnt = (unsigned short)0;
	trav_proc = (proc_t *)0;
#if 0
fprintf( stderr, "completed_cnt %lu\n", completed_cnt );
#endif

	for ( proc_ndx = (unsigned short)0; proc_ndx < proc_cnt; ++proc_ndx ) {
		proc = &proc_tbl[ proc_ndx ];

		if ( divvy_text == (char **)0 ) {
			partition_text = (char *)0;
		} else {
			partition_text = divvy_text[ proc_ndx ];
		}

		if ( completed_cnt > 0UL ) {
			if ( completed_status( &completed_successful_flag, &proc->status, completed, completed_cnt, partition_text, step_name, successful_exit_code ) == -1 ) {
				RETURN_INT( -1 );
			}

			if ( completed_successful_flag ) {
				continue;
			}
		}

		if ( divvy_text == (char **)0 ) {
			proc->partition = (char *)0;
		} else {
			proc->partition_ndx = proc_ndx;
			proc->partition = partition_text;
		}

		if ( trav_proc == (proc_t *)0 ) {
			/*
			** First link in list.
			*/
			*proc_list = proc;
			trav_proc = proc;
			trav_proc->prev = (proc_t *)0;
		} else {
			trav_proc->next = proc;
			proc->prev = trav_proc;
			trav_proc = proc;
		}

		++*proc_list_cnt;
		trav_proc->next = (proc_t *)0;
	}

	RETURN_INT( 0 );
}
