/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function requests a proc resource from the CPU semaphore.
*/
int request_proc_resource( int *resource_flag, unsigned short allocated_proc_cnt, int semid )
{
	int	ret;
	struct sembuf	sops;

	assert( resource_flag != (int *)0 );

	DEBUG_FUNC_START;

	ret = 0;

	sops.sem_num = 0;
	sops.sem_op = -1;
	sops.sem_flg = SEM_UNDO;

	if ( allocated_proc_cnt > (unsigned short)0 ) {
		sops.sem_flg |= IPC_NOWAIT;
	}

	if ( semop( semid, &sops, (size_t)1 ) == -1 ) {
		/*
		** Set resource flag to false.
		*/
		*resource_flag = 0;
		if ( errno == EAGAIN ) {
			if ( Debug ) {
				(void) fputs( "Failed to get CPU resource.\n", stderr );
			}
		} else {
			/*
			** Did not fail because IPC_NOWAIT was set.
			*/
			UNIX_ERROR( "semop() failed" );
			ret = -1;
		}
	} else {
		/*
		** Set resource flag to true.
		*/
		*resource_flag = 1;
	}

	RETURN_INT( ret );
}
