/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
*/

int open_log_file( const char *fname )
{
	int	fd;
	const mode_t	perm = S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH;
	char	msg[200];

	DEBUG_FUNC_START;

	if ( fname == (const char *)0 ) {
		/*
		** Send to stderr.
		*/
		RETURN_INT( 2 );
	}

	fd = open( fname, O_CREAT|O_WRONLY|O_APPEND|O_SYNC, perm );
	if ( fd < 0 ) {
		(void) strcpy( msg, "Cannot open log file [" );
		assert( sizeof( msg ) >= (size_t)200 );
		(void) strncat( msg, fname, (size_t)150 );
		(void) strcat( msg, "]" );
		UNIX_ERROR( msg );
		RETURN_INT( -1 );
	}

	RETURN_INT( fd );
}
