/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function retrieves semaphore key from configuration file and
** uses key to get semaphore ID.
*/
int get_cpu_semid( const char *fname )
{
	FILE	*fptr;
	char	buf[80];
	int	semid;
	key_t	semkey;
	size_t	len;

	DEBUG_FUNC_START;

	if ( fname == (const char *)0 ) {
		/*
		** Not used.
		*/
		RETURN_INT( -1 );
	}

	fptr = fopen( fname, "r" );
	if ( fptr == (FILE *)0 ) {
		UNIX_ERROR( "fopen() failed" );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Could not open CPU SEMKEY file [", stderr );
		(void) fputs( fname, stderr );
		(void) fputs( "].\n", stderr );
		RETURN_INT( -1 );
	}

	if ( fgets( buf, sizeof( buf ), fptr ) == (char *)0 ) {
		(void) fclose( fptr );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "CPU SEMKEY file [", stderr );
		(void) fputs( fname, stderr );
		(void) fputs( "] was empty.\n", stderr );
		RETURN_INT( -1 );
	}

	len = strlen( buf );
	if ( len == (size_t)0 ) {
		(void) fclose( fptr );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "fgets() returned a zero length string.\n", stderr );
		RETURN_INT( -1 );
	}

	--len;
	if ( buf[ len ] != '\n' ) {
		(void) fclose( fptr );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "fgets() did not read entire line.\n", stderr );
		RETURN_INT( -1 );
	}

	buf[ len ] = (char)0;
	semkey = (key_t)strtol( buf, (char **)0, 16 );

	semid = semget( semkey, 1, 0 );
	if ( semid == -1 ) {
		UNIX_ERROR( "semget() failed" );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "semget() failed using key [", stderr );
		(void) fputs( buf, stderr );
		(void) fputs( "].\n", stderr );
		RETURN_INT( -1 );
	}

	if ( fclose( fptr ) == EOF ) {
		UNIX_ERROR( "fclose() failed" );
	}

	RETURN_INT( semid );
}
