/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"

typedef struct {
	const char	*name;
	char	**value;
} field_t;


/*
** This function assigns information from control structure.
*/
int assign_step_attrib( step_t *ret_step, sexpr_t *field, unsigned short tuple_cnt )
{
	static step_t	step;
	char	*str, msg[128], *max_processes_str, *end_str;
	int	ret;
	sexpr_t	*field_attribute;
	static field_t	field_tbl[] = {
		{ "stdin",	&step.stdin_fname },
		{ "stdout",	&step.stdout_fname },
		{ "stderr",	&step.stderr_fname },
		{ "partition",	&step.partition }
	};

	const unsigned short	field_tbl_cnt = sizeof( field_tbl ) / sizeof( field_t );

	field_t	*fld;
	unsigned short	fld_ndx;

	assert( ret_step != (step_t *)0 );

	DEBUG_FUNC_START;

	(void) memset( (void *)&step, 0, sizeof( step_t ) );

	step.max_processes = (unsigned short)1;
	step.successful_exit[ 0 ] = (char)1;

	ret = assign_string( &step.step_name, field, "step", tuple_cnt );
	if ( ret == -1 ) {
		RETURN_INT( -1 );
	}

	assert( SEXPR_CDR_TYPE( field ) == list_sexpr );

	field = SEXPR_CDR_LIST( field );

	if ( field == (sexpr_t *)0 ) {
		CONTROL_SYNTAX_ERROR( "null list", tuple_cnt );
		RETURN_INT( -1 );
	}

	while ( field != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( field ) != list_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a list", tuple_cnt );
			RETURN_INT( -1 );
		}

		field_attribute = SEXPR_CAR_LIST( field );

		if ( SEXPR_CAR_TYPE( field_attribute ) != string_sexpr ) {
			CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
			RETURN_INT( -1 );
		}

		str = SEXPR_CAR_STRING( field_attribute );

		fld = field_tbl;
		for ( fld_ndx = field_tbl_cnt; fld_ndx > (unsigned short)0; --fld_ndx ) {
			if ( strcasecmp( str, fld->name ) == 0 ) {
				ret = assign_string( fld->value, SEXPR_CDR_LIST( field_attribute ), fld->name, tuple_cnt );
				break;
			}
			++fld;
		}

		if ( fld_ndx == (unsigned short)0 ) {
			if ( strcasecmp( str, "exec" ) == 0 ) {
				ret = assign_exec( &step.exec_arg, &step.exec_arg_cnt, SEXPR_CDR_LIST( field_attribute ), tuple_cnt );
			} else {
				if ( strcasecmp( str, "max-processes" ) == 0 ) {
					ret = assign_string( &max_processes_str, SEXPR_CDR_LIST( field_attribute ), "max-processes", tuple_cnt );
					step.max_processes = (unsigned short)strtoul( max_processes_str, &end_str, 10 );
					if ( max_processes_str == end_str || *end_str != (char)0 ) {
						(void) strcpy( msg, "max processes [" );
						(void) strncat( msg, max_processes_str, (size_t)40 );
						(void) strcat( msg, "] must be an integer" );
						CONTROL_SYNTAX_ERROR( msg, tuple_cnt );
						RETURN_INT( -1 );
					}
				} else {
					if ( strcasecmp( str, "successful-exit" ) == 0 ) {
						ret = assign_exit_values( step.successful_exit, SEXPR_CDR_LIST( field_attribute ), tuple_cnt );
					} else {
						(void) strcpy( msg, "unknown key word [" );
						(void) strncat( msg, str, (size_t)60 );
						(void) strcat( msg, "] encountered" );
						CONTROL_SYNTAX_ERROR( msg, tuple_cnt );
						RETURN_INT( -1 );
					}
				}
			}
		}

		if ( ret == -1 ) {
			RETURN_INT( -1 );
		}

		assert( SEXPR_CDR_TYPE( field ) == list_sexpr );
		field = SEXPR_CDR_LIST( field );
	}

	*ret_step = step;

	RETURN_INT( 0 );
}
