/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile_exec.h"


/*
** This function assigns file names to capture stdin, stdout and stderr
** of an application about to be started.
*/
int assign_fname( char **result_fname, const char *config_fname, unsigned short proc_ndx, unsigned short max_proc_ndx, const char *slice_text )
{
	char	*path;
	char	sequence[24];
	int	seq_nbr_len;

	/*
	** config_fname may be null.
	*/

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fprintf( stderr, "configured file path [%s], proc_ndx %hu, slice_text [%s]\n", ( config_fname ) ? config_fname : "NULL", proc_ndx, ( slice_text ) ? slice_text : "NULL" );
	}

	if ( config_fname == (const char *)0 ) {
		/*
		** Allow child process to inherit
		** parent's stdout and stderr.
		*/
		*result_fname = (char *)0;

		RETURN_INT( 0 );
	}

	/*
	** Figure max sequence number length.
	*/
	if ( max_proc_ndx > (unsigned short)10000 ) {
		seq_nbr_len = 5;
	} else {
		if ( max_proc_ndx > (unsigned short)1000 ) {
			seq_nbr_len = 4;
		} else {
			if ( max_proc_ndx > (unsigned short)100 ) {
				seq_nbr_len = 3;
			} else {
				if ( max_proc_ndx > (unsigned short)10 ) {
					seq_nbr_len = 2;
				} else {
					seq_nbr_len = 1;
				}
			}
		}
	}

	if ( snprintf( sequence, sizeof( sequence ), "%0*hu", seq_nbr_len, proc_ndx ) <= 0 ) {
		UNIX_ERROR( "sprintf() failed to convert proc_ndx to ASCII" );
		RETURN_INT( -1 );
	}

	path = strdup( config_fname );
	if ( path == (char *)0 ) {
		RETURN_INT( -1 );
	}

	if ( substitute_tokens( &path, sequence, slice_text ) == -1 ) {
		RETURN_INT( -1 );
	}

	*result_fname = path;

	if ( Debug ) {
		(void) fprintf( stderr, "file path [%s]\n", *result_fname );
	}

	RETURN_INT( 0 );
}
