/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <search.h>
#include <assert.h>
#include "tbox.h"
#include "rbtree.h"
#include "sexpr.h"
#include "dfile_exec.h"

static const char       rcsid[] = "$Id: assign_exec_args.c,v 1.2 2009/10/16 20:05:35 keith Exp $";

/*
** $Log: assign_exec_args.c,v $
** Revision 1.2  2009/10/16 20:05:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/06 10:15:42  keith
** Initial revision
**
*/

/*
** This function builds and parses commands to execute.
*/
int assign_exec_args( char ***result_arg, char **exec_arg, unsigned short exec_arg_cnt, const char *divvy_text, unsigned short divvy_ndx )
{
	char	**arg, **ptr;
	char	sequence[24];

	assert( result_arg != (char ***)0 );
	assert( exec_arg != (char **)0 );
	/*
	** divvy_text will be null.
	*/

	DEBUG_FUNC_START;

	/*
	** Search command line arguments for %n and %s flags.
	** These flags are replaced with slice sequence number
	** and partition name respectively.
	*/
	if ( snprintf( sequence, sizeof( sequence ), "%hu", divvy_ndx ) <= 0 ) {
		UNIX_ERROR( "sprintf() failed to convert proc_ndx to ASCII" );
		RETURN_INT( -1 );
	}


	if ( copy_exec_args( &arg, exec_arg, exec_arg_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	for ( ptr = arg; *ptr != (char *)0; ++ptr ) {
		/*
		** Replace %n and %s flags that occur in command.
		*/
		if ( substitute_tokens( ptr, sequence, divvy_text ) == -1 ) {
			RETURN_INT( -1 );
		}
	}

	*result_arg = arg;

	RETURN_INT( 0 );
}
