/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <unistd.h>
#include <sys/shm.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "where.h"
#include "dfile_cache_create.h"


/*
** This program loads a dfile into shared memory.
*/
int main( int argc, char **argv )
{
	const char	*dfile_name, *ipc_key, *input_filter_file_name;
	dfile_t	*dfile1, *dfile2;
	dfile_tag_t	*dfile_tag_tbl;
	unsigned short	dfile_tag_tbl_cnt;
	size_t	*field_size, record_size, record_cnt;
	int	shmid;
	char	err_msg[ 256 ];
	void	*input_filter;

	if ( get_args( argc, argv, &dfile_name, &dfile_tag_tbl, &dfile_tag_tbl_cnt, &ipc_key, &input_filter_file_name ) == -1 ) {
		return 5;
	}

	DEBUG_FUNC_START;

	if ( open_dfile( &dfile1, dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt ) == -1 ) {
		RETURN_INT( 20 );
	}

	if ( open_dfile( &dfile2, dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt ) == -1 ) {
		RETURN_INT( 21 );
	}

	if ( input_filter_file_name == (const char *)0 ) {
		input_filter = (void *)0;
	} else {
		if ( where_compile_file( &input_filter, err_msg, sizeof( err_msg ), input_filter_file_name, dfile1 ) != WHERE_NOERR ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "where_compile_file() failed [", stderr );
			(void) fputs( input_filter_file_name, stderr );
			(void) fputs( "]\n\t+ [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( 22 );
		}
	}

	if ( get_data_size( &record_size, &record_cnt, &field_size, dfile1, input_filter ) == -1 ) {
		RETURN_INT( 25 );
	}

	if ( create_shared_memory( &shmid, ipc_key, record_size, record_cnt, field_size, (size_t)dfile2->bind_cnt ) == -1 ) {
		RETURN_INT( 30 );
	}

	if ( input_filter_file_name == (const char *)0 ) {
		input_filter = (void *)0;
	} else {
		if ( where_compile_file( &input_filter, err_msg, sizeof( err_msg ), input_filter_file_name, dfile2 ) != WHERE_NOERR ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "where_compile_file() failed [", stderr );
			(void) fputs( input_filter_file_name, stderr );
			(void) fputs( "]\n\t+ [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( 35 );
		}
	}

	if ( fill_shared_memory( shmid, record_size, record_cnt, field_size, (size_t)dfile2->bind_cnt, dfile2, input_filter ) == -1 ) {
		RETURN_INT( 40 );
	}

	if ( smtable_readonly( shmid ) == -1 ) {
		RETURN_INT( 50 );
	}

#if 0
	(void) dfile_read_close( dfile1 );
	(void) dfile_read_close( dfile2 );
#endif

	RETURN_INT( 0 );
}
