/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <unistd.h>
#include <sys/shm.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_cache_create.h"


/*
** This function creates a shared memory segment.
*/
int create_shared_memory( int *ret_shmid, const char *ipc_key_str, size_t record_size, size_t record_cnt, size_t *field_size, size_t field_cnt )
{
	key_t	ipc_key;
	int	shmflg, shmid;
	char	*end_ptr;
	const int	hex = 16;
	size_t	alloc_size, header_size, data_size;

	assert( ret_shmid != (int *)0 );
	assert( ipc_key_str != (const char *)0 );
	assert( field_size != (size_t *)0 );

	DEBUG_FUNC_START;

	ipc_key = (key_t)strtol( ipc_key_str, &end_ptr, hex );

	if ( end_ptr == ipc_key_str || *end_ptr != (char)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "strtol() failed to convert hex value [", stderr );
		(void) fputs( ipc_key_str, stderr );
		(void) fputs( "] to an integer.\n", stderr );
		RETURN_INT( -1 );
	}

	/*
	** Header will contain an array of size_t values.
	**   1. record_cnt
	**   2. record_size
	**   3. field_cnt
	**   4. field 1 offset, field 2 offset, ..., field n offset
	*/
	header_size = sizeof( size_t ) * ( field_cnt + (size_t)3 );
	data_size = record_size * record_cnt;
	alloc_size = header_size + data_size;
	shmflg = 0640|IPC_CREAT|IPC_EXCL;

	shmid = shmget( ipc_key, alloc_size, shmflg );
	if ( shmid == -1 ) {
		UNIX_ERROR( "shmget() failed" );
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Failed to create shared memory segment [", stderr );
		(void) fputs( ipc_key_str, stderr );
		(void) fputs( "] containing [", stderr );
		(void) fput_uint( (unsigned int)alloc_size, stderr );
		(void) fputs( "] bytes.\n", stderr );
		RETURN_INT( -1 );
	}

	*ret_shmid = shmid;

	RETURN_INT( 0 );
}
