/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */


typedef enum { Unknown_func_type, Sum, Average, Num_min, Num_max, Str_min, Str_max, Count } func_type_t;

typedef struct {
	func_type_t	func_type;
	const char	*src_field_name;
	const char	*result_field_name;
	dfile_bind_t	*src_bind;
	dfile_bind_t	*result_bind;
	const char	*output_format;
	char		format_result[24];
	int		initialize_flag;
	union {
		char	*str;
		double	num;
	} value_u;
} func_t;

int get_args( int, char * const [], const char **, const char **, int *, int *, dfile_tag_t **, unsigned short *, const char **, func_t **, unsigned short *, const char **, const char ** );
int alloc_func( func_t **, unsigned short *, func_type_t, const char *, const char *, const char * );
int parse_field_list( const char **, const char **, const char * );
int open_dfile( dfile_t **, const char *, dfile_tag_t *, unsigned short, int, char );
int bind_func( func_t *, unsigned short, dfile_bind_t **, unsigned short, dfile_bind_t **, unsigned short );
int copy_bind( dfile_bind_t **, const dfile_bind_t **, size_t *, unsigned short );
int output_record( dfile_t *, unsigned long, func_t *, unsigned short, void * );
int process_agfunc( func_t * );
int process_file( dfile_t *, dfile_t *, const dfile_bind_t **, dfile_bind_t **, unsigned short, func_t *, unsigned short, void *, void * );
int parse_avg_sum_field_list( const char **, const char **, const char **, const char * );
int compile_filters( void **, void **, const char *, const char *, dfile_t *, dfile_t * );
int eval_agfunc( func_t *, unsigned long );
