/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <string.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"

static const char       rcsid[] = "$Id: where_compile_sexpr.c,v 1.2 2009/10/16 17:27:11 keith Exp $";

/*
** $Log: where_compile_sexpr.c,v $
** Revision 1.2  2009/10/16 17:27:11  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/18 06:19:14  keith
** Initial revision
**
*/

/*
** This is a wrapper function for _where_build_syntax_tree. It processes an
** s-expression structure into a syntax tree and does semantic checking. It
** returns a structure ready for the interpreter to process.
*/

int where_compile_sexpr( void **ret_condition, char *err_msg, size_t err_msg_size, void *sexpr, dfile_t *dfile )
{
	static const char func[] = "where_compile_sexpr";
	int	ret;

	assert( ret_condition != (void **)0 );
	assert( sexpr != (void *)0 );
	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	ret = _where_build_syntax_tree( (condition_t **)ret_condition, (sexpr_t *)sexpr, dfile );

	if ( ret != WHERE_NOERR ) {
		if ( err_msg != (char *)0 && err_msg_size > (size_t)0 ) {
			--err_msg_size;
			(void) strncpy( err_msg, where_error( ret ), err_msg_size );
			err_msg[ err_msg_size ] = (char)0;
		}
	}

	RETURN_INT( ret );
}
