/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"

static const char       rcsid[] = "$Id: _where_multi_datum_syntax.c,v 1.2 2009/10/16 17:27:11 keith Exp $";

/*
** $Log: _where_multi_datum_syntax.c,v $
** Revision 1.2  2009/10/16 17:27:11  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/18 06:10:31  keith
** Initial revision
**
*/

/*
** This function builds portion of syntax tree for data in operator expressions.
*/

int _where_multi_datum_syntax( multi_datum_t *multi_datum, sexpr_t *sexpr, dfile_t *dfile )
{
	static const char func[] = "_where_multi_datum_syntax";
	int	ret;
	datum_t	*datum, *new;
	unsigned long	datum_cnt;
	size_t	alloc_size;

	assert( multi_datum != (multi_datum_t *)0 );

	DEBUG_FUNC_START;

	multi_datum->datum = (datum_t *)0;
	multi_datum->datum_cnt = 0UL;

	datum = (datum_t *)0;
	datum_cnt = 0UL;

	while ( sexpr != (sexpr_t *)0 ) {
		alloc_size = ( (size_t)datum_cnt + (size_t)1 ) * sizeof( datum_t );
		new = (datum_t *)realloc( (void *)datum, alloc_size );
		if ( new == (datum_t *)0 ) {
			UNIX_ERROR( "realloc() failed" );
			RETURN_INT( WHERE_UNIXERR );
		}

		datum = new;

		if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Missing constant or variable value.\n", stderr );
			RETURN_INT( WHERE_SYNTAX );
		}

		ret = _where_datum_syntax( &datum[ datum_cnt ], SEXPR_CAR_STRING( sexpr ), dfile );

		if ( ret != WHERE_NOERR ) {
			RETURN_INT( ret );
		}

		++datum_cnt;

		sexpr = SEXPR_CDR_LIST( sexpr );
	}

	multi_datum->datum = datum;
	multi_datum->datum_cnt = datum_cnt;

	if ( Debug ) {
		(void) fprintf( stderr, "datum_cnt = %lu\n", datum_cnt );
	}

	RETURN_INT( WHERE_NOERR );
}
