/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"

static const char       rcsid[] = "$Id: format_hash_values.c,v 1.2 2009/10/16 17:02:35 keith Exp $";

/*
** $Log: format_hash_values.c,v $
** Revision 1.2  2009/10/16 17:02:35  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/01 05:37:13  keith
** Initial revision
**
*/

static size_t assign_width( unsigned short );

/*
** This function formats hash value numbers into strings.
*/
int format_hash_values( const char ***divvy_text, unsigned short divvy_text_cnt )
{
	static const char	func[] = "format_hash_values";
	unsigned short	ndx;
	size_t	width, size;
	char	*partition_str, **partition_tbl;

	assert( divvy_text != (const char ***)0 );

	DEBUG_FUNC_START;

	size = sizeof(char **) * (size_t)divvy_text_cnt;
	partition_tbl = (char **)malloc( size );
	if ( partition_tbl == (char **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	*divvy_text = (const char **)partition_tbl;

	width = assign_width( divvy_text_cnt );
	size = width + (size_t)1;

	for ( ndx = (unsigned short)0; ndx < divvy_text_cnt; ++ndx ) {
		partition_str = (char *)malloc( size );
		if ( partition_str == (char *)0 ) {
			UNIX_ERROR( "malloc() failed" );
			RETURN_INT( -1 );
		}

		if ( snprintf( partition_str, size, "%0*hu", width, ndx ) != width ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Failed to convert integer into string.\n", stderr );
			RETURN_INT( -1 );
		}

		*partition_tbl = partition_str;
		++partition_tbl;
	}

	RETURN_INT( 0 );
}

static size_t assign_width( unsigned short x )
{
	if ( x > (unsigned short)10000 ) {
		return (size_t)5;
	}

	if ( x > (unsigned short)1000 ) {
		return (size_t)4;
	}

	if ( x > (unsigned short)100 ) {
		return (size_t)3;
	}

	if ( x > (unsigned short)10 ) {
		return (size_t)2;
	}

	return (size_t)1;
}
