/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"

static const char       rcsid[] = "$Id: map_dfile_field_names.c,v 1.3 2009/10/16 16:53:52 keith Exp $";

/*
** $Log: map_dfile_field_names.c,v $
** Revision 1.3  2009/10/16 16:53:52  keith
** Added GPL to source code.
**
** Revision 1.2  2009/03/13 06:47:18  keith
** Added limits.h header file.
**
** Revision 1.1  2009/03/01 03:22:07  keith
** Initial revision
**
*/

/*
** This function maps field names between two bind arrays.
*/
int map_dfile_field_names( unsigned short **map_ndx_tbl, dfile_bind_t *to_bind, unsigned short to_bind_cnt, dfile_bind_t *from_bind, void *from_bind_hash_table )
{
	static const char	func[] = "map_dfile_field_names";
	unsigned short	i, map_cnt, *map_ndx;
	size_t	alloc_size;
	dfile_bind_t	**bind_entry;

	assert( map_ndx_tbl != (unsigned short **)0 );
	assert( to_bind != (dfile_bind_t *)0 );
	assert( to_bind_cnt > (unsigned short)0 );
	assert( from_bind != (dfile_bind_t *)0 );
	assert( from_bind_hash_table != (void *)0 );

	DEBUG_FUNC_START;

	*map_ndx_tbl = (unsigned short *)0;

	alloc_size = (size_t)to_bind_cnt * sizeof( unsigned short );
	map_ndx = (unsigned short *)malloc( alloc_size );
	if ( map_ndx == (unsigned short *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	map_cnt = (unsigned short)0;

	for ( i = (unsigned short)0; i < to_bind_cnt; ++i ) {
		bind_entry = (dfile_bind_t **)dhfind( (void *)to_bind, from_bind_hash_table, strhkey( to_bind->field_name ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			/*
			** USHRT_MAX is a special value to signal
			** unmapped field.
			*/
			map_ndx[ i ] = USHRT_MAX;
			continue;
		}

		if ( Debug ) {
			(void) fprintf( stderr, "[%s] match\n", to_bind->field_name );
		}

		++map_cnt;
		assert( *bind_entry >= from_bind );
		map_ndx[ i ] = (unsigned short)( *bind_entry - from_bind );
		++to_bind;
	}

	*map_ndx_tbl = map_ndx;

	if ( Debug ) {
		(void) fprintf( stderr, "Mapped %hu of %hu fields.\n", map_cnt, to_bind_cnt );
	}

	RETURN_INT( 0 );
}
