/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_var_rec_refill_ascii_buffer.c,v 1.2 2009/10/16 07:35:57 keith Exp $";

/*
** $Log: _dfile_var_rec_refill_ascii_buffer.c,v $
** Revision 1.2  2009/10/16 07:35:57  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/28 05:03:29  keith
** Initial revision
**
*/

/*
** This function refills a buffer with ASCII data.
*/

int _dfile_var_rec_refill_ascii_buffer( dfile_t *dfile )
{
	static const char	func[] = "_dfile_var_rec_refill_ascii_buffer";
	dfile_buffer_t	*buffer;
	char	*buffer_area, *buf_ptr_end;
	ssize_t	read_byte_cnt;

	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	assert( dfile->buffer_length > (size_t)0 );
	buffer = dfile->io_buffer;
	assert( buffer != (dfile_buffer_t *)0 );
	buffer_area = buffer->buffer_area;
	assert( buffer_area != (char *)0 );

	read_byte_cnt = read( dfile->open_descriptor, buffer_area, dfile->buffer_length );
	if ( read_byte_cnt < (ssize_t)0 ) {
		dfile->error = Dfile_io_failed;
		buffer->processing_complete_flag = 'Y';
		UNIX_ERROR( "read() failed" );
		RETURN_INT( -1 );
	}

	if ( read_byte_cnt == (ssize_t)0 ) {
		dfile->error = Dfile_end_of_file;
		RETURN_INT( -1 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "refilled buffer: read %d\n", read_byte_cnt );
	}

	buffer->buf_ptr = buffer_area;
	buf_ptr_end = &buffer_area[ read_byte_cnt ];

	/*
	** Null terminate buffer because parsing routine will sometimes
	** use value at end of buffer as field length value.
	*/
	*buf_ptr_end = (char)0;

	buffer->buf_ptr_end = buf_ptr_end;
	buffer->buffer_rec_cnt = 0UL;

	if ( Debug ) {
		(void) fprintf( stderr, "buf_ptr = %p, buf_ptr_end = %p\n", buffer->buf_ptr, buffer->buf_ptr_end );
	}
	RETURN_INT( 0 );
}
