/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <limits.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_sub_tags.c,v 1.2 2009/10/16 07:35:56 keith Exp $";

/*
** $Log: _dfile_sub_tags.c,v $
** Revision 1.2  2009/10/16 07:35:56  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/28 04:31:46  keith
** Initial revision
**
*/

/*
** This function substitutes file name tags.
*/

const char *_dfile_sub_tags( const char *fname, const dfile_tag_t *tag, unsigned short tag_cnt )
{
	static const char	func[] = "_dfile_sub_tags";
	char	file_path[PATH_MAX+1];
	const char	*result;
	size_t	len;

	DEBUG_FUNC_START;

	len = strlen( fname );

	if ( len >= sizeof( file_path ) ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "file path [", stderr );
		(void) fputs( fname, stderr );
		(void) fputs( "] exceeds maximum length ", stderr );
		(void) fput_uint( sizeof( file_path ), stderr );
		(void) fputs( ".\n", stderr );
		RETURN_POINTER( (const char *)0 );
	}

	(void) memcpy( (void *)file_path, (void *)fname, len + (size_t)1 );

	for ( ; tag_cnt > (unsigned short)0; --tag_cnt ) {
		if ( substitute_str( file_path, sizeof( file_path ), tag->tag, tag->tag_value ) == -1 ) {
			RETURN_POINTER( (const char *)0 );
		}
		++tag;
	}

	result = (const char *)strdup( file_path );
	if ( result == (const char *)0 ) {
		UNIX_ERROR( "strdup() failed" );
		RETURN_POINTER( (const char *)0 );
	}

	RETURN_POINTER( result );
}
