/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_resize_overflow.c,v 1.2 2009/10/16 07:35:56 keith Exp $";

/*
** $Log: _dfile_resize_overflow.c,v $
** Revision 1.2  2009/10/16 07:35:56  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/28 03:29:22  keith
** Initial revision
**
*/

/*
** This function resizes overflow memory when necessary.
*/

int _dfile_resize_overflow( char **overflow, size_t *overflow_size, size_t required_size )
{
	static const char	func[] = "_dfile_resize_overflow";
	const size_t	minimum_size = 500;
	char	*new;

	assert( overflow != (char **)0 );
	assert( overflow_size != (size_t *)0 );

	DEBUG_FUNC_START;

	if ( *overflow_size >= required_size ) {
		RETURN_INT( 0 );
	}

	if ( minimum_size > required_size ) {
		required_size = minimum_size;
	}

	new = (char *)realloc( *overflow, required_size );
	if ( new == (char *)0 ) {
		UNIX_ERROR( "realloc() failed" );
		RETURN_INT( -1 );
	}

	*overflow = new;
	*overflow_size = required_size;

	RETURN_INT( 0 );
}
