/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_parse_escaped_field.c,v 1.2 2009/10/16 07:35:55 keith Exp $";

/*
** $Log: _dfile_parse_escaped_field.c,v $
** Revision 1.2  2009/10/16 07:35:55  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/26 02:11:21  keith
** Initial revision
**
*/

static void escaped_shift( char *, char *, char, char, char );

/*
** This function parses a field from record in the escaped separator format.
** The escaped separator format consists of a character being inserted to
** prefix field and record separator characters found in data. Special
** escape and separator characters are removed during parsing.
*/

dfile_parse_t _dfile_parse_escaped_field( char **buf_ptr, size_t *length, dfile_rec_t rec_attribute )
{
	register char	*ptr;
	register char	record_separator, field_separator;
	int	separator_escaped_flag;
	char	ch, escape;

	assert( buf_ptr != (char **)0 );

	ptr = *buf_ptr;

	assert( ptr != (char *)0 );

	field_separator = rec_attribute.field_separator;

	if ( *ptr == field_separator ) {
		*ptr = (char)0;
		*length = (size_t)0;
		++*buf_ptr;
		return Dfile_parsed_field;
	}

	record_separator = rec_attribute.record_separator;

	if ( *ptr == record_separator ) {
		*ptr = (char)0;
		*length = (size_t)0;
		++*buf_ptr;
		return Dfile_parsed_record;
	}

	escape = rec_attribute.separator_escape;

	/*
	** Initialize separator_escaped_flag to false.
	*/
	separator_escaped_flag = 0;

	for ( ;; ) {
		++ptr;

		if ( *ptr == field_separator || *ptr == record_separator ) {
			if ( ptr[ -1 ] == escape ) {
				/*
				** An escaped delimiter character.
				** Set separator_escaped_flag to true.
				*/
				separator_escaped_flag = 1;
			} else {
				/*
				** End of field or record.
				*/
				break;
			}
		}
	}

	ch = *ptr;

	/*
	** Replace separator character with null.
	*/
	*ptr = (char)0;

	if ( separator_escaped_flag ) {
		escaped_shift( *buf_ptr, ptr, field_separator, record_separator, escape );
		*length = strlen( *buf_ptr );
	} else {
		*length = (size_t)( ptr - *buf_ptr );
	}

	*buf_ptr = &ptr[ 1 ];

	return ( ch == field_separator ) ? Dfile_parsed_field : Dfile_parsed_record;
}

static void escaped_shift( register char *str, char *str_end, char field_separator, char record_separator, char escape )
{
	register unsigned	shift_cnt;

	shift_cnt = (unsigned)0;

	while ( str < str_end ) {
		if ( str[ shift_cnt ] == escape && ( str[ shift_cnt + 1 ] == field_separator || str[ shift_cnt + 1 ] == record_separator ) ) {
			++shift_cnt;
		}
		if ( shift_cnt > (unsigned short)0 ) {
			*str = str[ shift_cnt ];
			if ( &str[ shift_cnt ] >= str_end ) {
				/*
				** Copied last (null) character.
				*/
				break;
			}
		}
		++str;
	}

	assert( *str == (char)0 );
}
