/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"

static const char       rcsid[] = "$Id: _dfile_bind.c,v 1.2 2009/10/16 07:35:53 keith Exp $";

/*
** $Log: _dfile_bind.c,v $
** Revision 1.2  2009/10/16 07:35:53  keith
** Add GPL to source code.
**
** Revision 1.1  2009/02/20 15:30:54  keith
** Initial revision
**
*/

/*
** This function joins pgm_var and cfg_bind arrays using field_name values.
** Variable pgm_var is expected to contain the application's C variables, and
** cfg_bind is expected to contain fields for record definition.
** Address of program host variables are copied from pgm_var to corresponding
** entries in cfg_bind.
*/

int _dfile_bind( dfile_bind_t *cfg_bind, unsigned short cfg_bind_cnt, const dfile_bind_t *pgm_var, unsigned short pgm_var_cnt, void *hash_table )
{
	static const char	func[] = "_dfile_bind";
	int	fatal_error_flag;
	dfile_bind_t	**bind_entry, *update_bind;
	unsigned short	ndx;

	assert( cfg_bind != (dfile_bind_t *)0 );
	assert( cfg_bind_cnt > (unsigned short)0 );
	assert( hash_table != (void *)0 );

	DEBUG_FUNC_START;

	/*
	** Set fatal_error_flag to false.
	*/
	fatal_error_flag = 0;

	for ( ndx = (unsigned short)0; ndx < pgm_var_cnt; ++ndx ) {
		bind_entry = (dfile_bind_t **)dhfind( (void *)pgm_var, hash_table, strhkey( pgm_var->field_name ), dfile_bind_field_name_cmp );

		if ( bind_entry == (dfile_bind_t **)0 ) {
			/*
			** Set fatal_error_flag to true.
			*/
			fatal_error_flag = 1;

			FPUT_SRC_CODE( stderr );
			(void) fputs( "Failed to match program bind variable [", stderr );
			(void) fputs( pgm_var->field_name, stderr );
			(void) fputs( "] with record layout.\n", stderr );

			++pgm_var;
			continue;
		}

		if ( Debug ) {
			(void) fprintf( stderr, "[%s], %p %p\n", pgm_var->field_name, pgm_var->field_buffer, pgm_var->field_length );
		}

		update_bind = *bind_entry;
		update_bind->field_buffer = pgm_var->field_buffer;
		update_bind->field_length = pgm_var->field_length;

		++pgm_var;
	}

	if ( fatal_error_flag ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
