/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

/*
**  $Id: _where.h,v 1.2 2009/10/16 17:26:43 keith Exp $
**
** $Log: _where.h,v $
** Revision 1.2  2009/10/16 17:26:43  keith
** Added GPL to source code.
**
** Revision 1.1  2009/02/18 06:33:08  keith
** Initial revision
**
*/
typedef enum { Unknown_constant, Real, Literal } constant_type_t;

typedef struct {
	constant_type_t	constant_type;
	union {
		double	real;
		char	*literal;
	} const_value_u;
} constant_t;

typedef enum { Unknown_datum, Constant, Variable } datum_type_t;

typedef struct {
	datum_type_t	datum_type;
	union {
		dfile_bind_t	*dfile_bind;
		constant_t	constant;
	} datum_u;
} datum_t;

typedef struct {
	unsigned long	datum_cnt;
	datum_t		*datum;
} multi_datum_t;

typedef struct {
	dfile_bind_t	*dfile_bind;
	void		*hash_table;
} in_cond_t;

typedef struct {
	dfile_bind_t	*dfile_bind;
	void	*regex;
} like_cond_t;

typedef struct condition_s	condition_t;

typedef struct {
	unsigned long	condition_cnt;
	condition_t	*condition;
} multi_cond_t;

typedef enum { Unknown_operation, Equal, Greater, Greater_or_equal, Less, Less_or_equal, In, Between, Like, Not, And, Or, Datum_value } operation_type_t;

struct condition_s {
	operation_type_t	operation_type;
	union {
		multi_cond_t	multi_condition;
		multi_datum_t	multi_datum;
		in_cond_t	in_condition;
		like_cond_t	like_condition;
	} condition_u;
};

#define	DATUM_TYPE( x )		( ( x )->datum_type )
#define	DATUM_CONST_TYPE( x )	( ( x )->datum_u.constant.constant_type )
#define	DATUM_CONST_LITERAL( x )( ( x )->datum_u.constant.const_value_u.literal )
#define	DATUM_CONST_REAL( x )	( ( x )->datum_u.constant.const_value_u.real )
#define	DATUM_VAR_BIND( x )	( ( x )->datum_u.dfile_bind )
#define	DATUM_VAR_BIND_STR( x )	( *( x )->datum_u.dfile_bind->field_buffer )

#define COND_OP( x )		( ( x )->operation_type )
#define COND_MULTI_COND( x )	( &( x )->condition_u.multi_condition )
#define COND_MULTI_COND_CNT( x )( ( x )->condition_u.multi_condition.condition_cnt )
#define COND_MULTI_DATUM( x )	( ( x )->condition_u.multi_datum )
#define COND_MULTI_DATUM_CNT( x )( ( x )->condition_u.multi_datum.datum_cnt )

#define COND_IN( x )		( &( x )->condition_u.in_condition )
#define COND_LIKE( x )		( &( x )->condition_u.like_condition )

int _where_build_syntax_tree( condition_t **, sexpr_t *, dfile_t * );
int _where_condition_syntax( condition_t *, sexpr_t *, dfile_t * );
int _where_multi_cond_syntax( multi_cond_t *, sexpr_t *, dfile_t * );
int _where_compare_syntax( condition_t *, const char *, sexpr_t *, dfile_t * );
int _where_multi_datum_syntax( multi_datum_t *, sexpr_t *, dfile_t * );
int _where_datum_syntax( datum_t *, char *, dfile_t * );
int _where_multi_condition( where_result_t *, multi_cond_t *, operation_type_t );
int _where_compare_condition( int *, multi_datum_t * );
int _where_condition( where_result_t *, condition_t * );
int _where_in_syntax( in_cond_t *, sexpr_t *, dfile_t * );
int _where_in_condition( where_result_t *, in_cond_t * );
int _where_like_syntax( like_cond_t *, sexpr_t *, dfile_t * );
int _where_like_condition( where_result_t *, like_cond_t * );
