/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "dfile_unique.h"

static const char       rcsid[] = "$Id: main.c,v 1.2 2009/10/16 20:26:12 keith Exp $";

/*
** $Log: main.c,v $
** Revision 1.2  2009/10/16 20:26:12  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/12 18:03:08  keith
** Initial revision
**
*/

/*
** This program outputs the last transaction per key.
*/
int main( int argc, char **argv )
{
	static const char	func[] = "main";
	const char	*input_dfile_name, *output_dfile_name;
	const char	*input_filter_file_name, *output_filter_file_name;
	dfile_t	*output_dfile, *input_dfile;
	int	thread_input_flag, thread_output_flag;
	dfile_tag_t	*dfile_tag_tbl;
	unsigned short	dfile_tag_tbl_cnt, *field_ndx_tbl;
	const char	**key_tbl;
	unsigned short	key_tbl_cnt;
	dfile_bind_t	**key_bind_tbl;
	void	*input_filter, *output_filter;
	char	*unique_key;

	if ( get_args( argc, argv, &input_dfile_name, &output_dfile_name, &thread_input_flag, &thread_output_flag, &dfile_tag_tbl, &dfile_tag_tbl_cnt, &input_filter_file_name, &output_filter_file_name, &unique_key ) == -1 ) {
		return 5;
	}

	DEBUG_FUNC_START;

	if ( parse_unique_key( &key_tbl, &key_tbl_cnt, unique_key ) == -1 ) {
		RETURN_INT( 10 );
	}

	if ( open_dfile( &input_dfile, input_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_input_flag, 'r' ) == -1 ) {
		RETURN_INT( 20 );
	}

	if ( open_dfile( &output_dfile, output_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, thread_output_flag, 'w' ) == -1 ) {
		RETURN_INT( 30 );
	}

	if ( assign_field_bind( &key_bind_tbl, key_tbl, key_tbl_cnt, input_dfile->bind_hash_table ) == -1 ) {
		RETURN_INT( 35 );
	}

	if ( map_dfile_field_names( &field_ndx_tbl, output_dfile->bind, output_dfile->bind_cnt, input_dfile->bind, input_dfile->bind_hash_table ) == -1 ) {
		RETURN_INT( 40 );
	}

	if ( compile_filters( &input_filter, &output_filter, (char *)input_filter_file_name, (char *)output_filter_file_name, input_dfile, output_dfile ) == -1 ) {
		RETURN_INT( 55 );
	}

	if ( process_file( output_dfile, input_dfile, key_bind_tbl, key_tbl_cnt, field_ndx_tbl, input_filter, output_filter ) == -1 ) {
		RETURN_INT( 60 );
	}

#if 0
	(void) dfile_read_close( input_dfile );
	(void) dfile_read_close( join_dfile );
#endif

	if ( dfile_write_close( output_dfile ) == -1 ) {
		RETURN_INT( 70 );
	}

	RETURN_INT( 0 );
}
