/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: open_input.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: open_input.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/12 12:39:46  keith
** Initial revision
**
*/

/*
** This function opens a data file for reading.
*/
int open_input( dfile_t **dfile, const char *dfile_name, dfile_tag_t *tag_tbl, unsigned short tag_tbl_cnt, unsigned short blocks_per_buffer_cnt, unsigned short buffer_cnt )
{
	static const char	func[] = "open_input";
	dfile_cfg_t	cfg;

	assert( dfile != (dfile_t **)0 );
	assert( dfile_name != (const char *)0 );

	DEBUG_FUNC_START;

	*dfile = (dfile_t *)0;

	if ( dfile_cfg( &cfg, dfile_name ) == -1 ) {
		RETURN_INT( -1 );
	}

	*dfile = dfile_read_open( &cfg, (dfile_bind_t *)0, (unsigned short)0, tag_tbl, tag_tbl_cnt, blocks_per_buffer_cnt, buffer_cnt );
	if ( *dfile == (dfile_t *)0 ) {
		RETURN_INT( -1 );
	}

	RETURN_INT( 0 );
}
