/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: assign_sort_dfile_attribute.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: assign_sort_dfile_attribute.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/09 15:48:25  keith
** Initial revision
**
*/

/*
** This function assigns information from control structure.
*/
int assign_sort_dfile_attribute( sm_dfile_t *sort, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	func[] = "assign_sort_dfile_attribute";
	char	*str;
	int	ret;

	assert( sort != (sm_dfile_t *)0 );

	DEBUG_FUNC_START;

	if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
		CONTROL_SYNTAX_ERROR( "expected a string", tuple_cnt );
		RETURN_INT( -1 );
	}

	str = SEXPR_CAR_STRING( sexpr );
	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	if ( strcasecmp( str, "tag" ) == 0 ) {
		ret = assign_tag( &sort->tag, &sort->tag_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "blocks-per-buffer" ) == 0 ) {
		ret = assign_ushort( &sort->blocks_per_buffer_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "buffer-count" ) == 0 ) {
		ret = assign_ushort( &sort->buffer_cnt, SEXPR_CDR_LIST( sexpr ), tuple_cnt );
		RETURN_INT( ret );
	}

	if ( strcasecmp( str, "where" ) == 0 ) {
		sort->where = sexpr;
		RETURN_INT( 0 );
	}

	RETURN_INT( -1 );
}
