/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "sexpr.h"
#include "dfile_utility.h"
#include "dfile_sort.h"

static const char       rcsid[] = "$Id: assign_field_attribute.c,v 1.2 2009/10/16 20:22:24 keith Exp $";

/*
** $Log: assign_field_attribute.c,v $
** Revision 1.2  2009/10/16 20:22:24  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/09 05:01:54  keith
** Initial revision
**
*/

static int set_ascend_descend( char *, const char * );
static int set_value_type( char *, const char * );

/*
** This function assigns information from control structure.
*/
int assign_field_attribute( order_by_t *order_by, sexpr_t *sexpr, unsigned short tuple_cnt )
{
	static const char	func[] = "assign_field_attribute";
	char	*str;

	assert( order_by != (order_by_t *)0 );

	DEBUG_FUNC_START;

	while ( sexpr != (sexpr_t *)0 ) {
		if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr ) {
			control_syntax_error( "expected a string", __FILE__, __LINE__, tuple_cnt );
			RETURN_INT( -1 );
		}

		str = SEXPR_CAR_STRING( sexpr );

		if ( set_ascend_descend( &order_by->ascend_descend, str ) == -1 ) {
			if ( set_value_type( &order_by->value_type, str ) == -1 ) {
				control_syntax_error( "expected [ascending|decending] or [ascii|numeric|high-value-null]", __FILE__, __LINE__, tuple_cnt );

				RETURN_INT( -1 );
			}
		}

		assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

		sexpr = SEXPR_CDR_LIST( sexpr );
	}

	RETURN_INT( 0 );
}

static int set_ascend_descend( char *ascend_descend, const char *str )
{
	if ( strcmp( str, "ascending" ) == 0 ) {
		*ascend_descend = 'A';
	} else {
		if ( strcmp( str, "descending" ) == 0 ) {
			*ascend_descend = 'D';
		} else {
			return -1;
		}
	}

	if ( Debug ) {
		(void) fprintf( stderr, "ascend_decend = [%c]\n", *ascend_descend );
	}

	return 0;
}

static int set_value_type( char *value_type, const char *str )
{
	if ( strcmp( str, "ascii" ) == 0 ) {
		*value_type = 'A';
	} else {
		if ( strcmp( str, "numeric" ) == 0 ) {
			*value_type = 'N';
		} else {
			if ( strcmp( str, "high-value-null" ) == 0 ) {
				*value_type = 'H';
			} else {
				return -1;
			}
		}
	}

	if ( Debug ) {
		(void) fprintf( stderr, "value_type = [%c]\n", *value_type );
	}

	return 0;
}
