/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "dfile_partition.h"

static const char       rcsid[] = "$Id: open_input.c,v 1.2 2009/10/16 20:16:47 keith Exp $";

/*
** $Log: open_input.c,v $
** Revision 1.2  2009/10/16 20:16:47  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 21:18:02  keith
** Initial revision
**
*/

/*
** This function opens a data file for reading.
*/
int open_input( dfile_t **dfile, char ***key_field, dfile_tag_t *common_tag_tbl, unsigned short common_tag_tbl_cnt, dfile_tag_t *input_tag_tbl, unsigned short input_tag_tbl_cnt, int thread_input_flag, const char *dfile_name, char *partition_field_name )
{
	static const char	func[] = "open_input";
	const unsigned short	blocks_per_buffer_cnt = 4;
	const unsigned short	thread_buffer_cnt = 4;
	const unsigned short	no_thread_buffer_cnt = 1;
	unsigned short	buffer_cnt;
	dfile_cfg_t	cfg;
	dfile_bind_t	key_bind, **bind_ptr;

	assert( dfile != (dfile_t **)0 );
	assert( key_field != (char ***)0 );
	assert( dfile_name != (const char *)0 );
	assert( partition_field_name != (char *)0 );

	DEBUG_FUNC_START;

	*dfile = (dfile_t *)0;

	if ( dfile_cfg( &cfg, dfile_name ) == -1 ) {
		RETURN_INT( -1 );
	}

	buffer_cnt = ( thread_input_flag ) ? thread_buffer_cnt : no_thread_buffer_cnt ;

	if ( append_tag( &input_tag_tbl, &input_tag_tbl_cnt, common_tag_tbl, common_tag_tbl_cnt ) == -1 ) {
		RETURN_INT( -1 );
	}

	*dfile = dfile_read_open( &cfg, (dfile_bind_t *)0, (unsigned short)0, input_tag_tbl, input_tag_tbl_cnt, blocks_per_buffer_cnt, buffer_cnt );
	if ( *dfile == (dfile_t *)0 ) {
		RETURN_INT( -1 );
	}

	strtoupper( partition_field_name );
	key_bind.field_name = partition_field_name;

	bind_ptr = (dfile_bind_t **)dhfind( (void *)&key_bind, ( *dfile )->bind_hash_table, strhkey( partition_field_name ), dfile_bind_field_name_cmp );

	if ( bind_ptr == (dfile_bind_t **)0 ) {
		fput_src_code( __FILE__, __LINE__, stderr );
		(void) fputs( "partition field [", stderr );
		(void) fputs( partition_field_name, stderr );
		(void) fputs( "] was not found in record layout.\n", stderr );
		RETURN_INT( -1 );
	}

	*key_field = ( *bind_ptr )->field_buffer;

	RETURN_INT( 0 );
}
