/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_partition.h"

static const char       rcsid[] = "$Id: divvy_cmp.c,v 1.2 2009/10/16 20:16:47 keith Exp $";

/*
** $Log: divvy_cmp.c,v $
** Revision 1.2  2009/10/16 20:16:47  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 20:51:04  keith
** Initial revision
**
*/

/*
** This function is used for comparing partition values.
*/
int divvy_cmp( const void *x, const void *y )
{
	assert( x != (const void *)0 );
	assert( y != (const void *)0 );

	return strcmp( *(const char **)x, *(const char **)y );
}
