/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"

static const char       rcsid[] = "$Id: copy_record_to_bind.c,v 1.2 2009/10/16 20:07:58 keith Exp $";

/*
** $Log: copy_record_to_bind.c,v $
** Revision 1.2  2009/10/16 20:07:58  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 08:35:18  keith
** Initial revision
**
*/

/*
** This function copies a stored record to a bind structure.
*/
void copy_record_to_bind( dfile_bind_t **bind, field_t *rec, unsigned short field_ndx_tbl_cnt )
{
	static const char	func[] = "copy_record_to_bind";
	dfile_bind_t	*bind_ptr;

	/*
	** bind and rec can be null
	** when no fields need copying to output (field_ndx_tbl_cnt is zero).
	*/

	DEBUG_FUNC_START;

	for ( ; field_ndx_tbl_cnt > (unsigned short)0; --field_ndx_tbl_cnt ) {
		bind_ptr = *bind;
		*bind_ptr->field_buffer = rec->value;
		*bind_ptr->field_length = rec->length;
		++bind;
		++rec;
	}

	RETURN_VOID;
}
