/* Copyright (C) 2009 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "sexpr.h"
#include "dfile_join.h"

static const char       rcsid[] = "$Id: copy_input_to_output.c,v 1.2 2009/10/16 20:07:58 keith Exp $";

/*
** $Log: copy_input_to_output.c,v $
** Revision 1.2  2009/10/16 20:07:58  keith
** Added GPL to source code.
**
** Revision 1.1  2009/03/08 07:23:41  keith
** Initial revision
**
*/

/*
** This function copies input field values to output bind structure array.
*/
void copy_input_to_output( dfile_bind_t **output_bind, const dfile_bind_t **input_bind, unsigned short bind_cnt )
{
	static const char	func[] = "copy_input_to_output";
	const dfile_bind_t	*in_bind;
	dfile_bind_t	*out_bind;

	assert( output_bind != (dfile_bind_t **)0 );
	assert( input_bind != (const dfile_bind_t **)0 );

	DEBUG_FUNC_START;

	for ( ; bind_cnt > (unsigned short)0; --bind_cnt ) {
		in_bind = *input_bind;
		out_bind = *output_bind;

		*out_bind->field_buffer = *in_bind->field_buffer;
		*out_bind->field_length = *in_bind->field_length;

		++input_bind;
		++output_bind;
	}

	RETURN_VOID;
}
